﻿/**
* @brief  本例程测试FlexRay通讯功能
*
* @copyright 天津优蓝科技有限公司 (http://www.ulantec.cn)
*/
#include <QCoreApplication>

#include "UBusCommLibWrapper.h"
#include <QTime>
#include <QDateTime>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <windows.h>
#include <QThread>
#include "main.h"

/*
 * 本例程通过宏定义区分不同工作模式下的FlexRay接口的软件编程方法
 *
*/

//是否使用fibex数据库文件加载总线参数和获得帧信息
#define USEFIBEX            0
#define USE_FRAME_NAME_TRANSMIT    0   //动态库1.5.0版本后支持通过帧名配置和发送数据
//定义是否使用发送唤醒功能，如果为1，节点将在启动总线前发送唤醒指令
#define SEND_WAKEUP         0
//定义是否使用FIFO模式监听总线消息
#define USE_FIFO_MODE       0
//定义是否使用回放模式进行总线消息回放操作
#define USE_REPLAY_MODE     0
//定义是否使用2个keyslot，即两个冷启动节点
#define USE_TWO_KEYSLOT     0


#if USEFIBEX  //参数信息直接从fibex文件获得，无需配置
FlexrayClusterParameter_t mFlexrayClusterParameter;
FlexrayNodeParameter_t mFlexrayNodeParameter;
FlexrayCCParameter_t mFlexrayCCParameter;
FlexrayMsgBufferParameter_t gFlexrayMsgBufferParameter[20];
#else
//初始化flexray总线的cluster参数
FlexrayClusterParameter_t mFlexrayClusterParameter{
        10,  //uint8_t gColdstartAttempts;             /*!< Number of coldstart node in network (Range: 2->31) */
        7,   //uint8_t gdActionPointOffset;            /*!< Number of macroticks the action point is offset from the beginning of a static slot or symbol window; value into range: 1-63MT. */
        91,  //uint8_t gdCASRxLowMax;                  /*!< Upper limit of the CAS acceptance window; value into range: 67-99 gdBit */
        1,   //uint8_t gdDynamicSlotIdlePhase;         /*!< Duration of the idle phase within a dynamic slot. from 0 to 2 */
        10,  //uint8_t gdMinislot;
        5,   //uint8_t gdMinislotActionPointOffset;    /*!< Number of macroticks the minislot action point is offset from the beginning of a minislot value into range: 1-31MT */
        50, //uint16_t gdStaticSlot;                  /*!< Duration of a static slot (4->661 MT) */
        0,   //uint8_t gdSymbolWindow;
        11,  //uint8_t gdTSSTransmitter;               /*!< number of bits in the Transmission Start Sequence(3-15gdBit) */
        59,  //uint8_t gdWakeupSymbolRxIdle;           /*!< Number of bits used by the node to test the duration of the 'idle' portion of a received wakeup symbol (14-59gdBit) */
        55,  //uint8_t gdWakeupSymbolRxLow;            /*!< Number of bits used by the node to test the LOW portion of a received wakeup symbol (11-59gdBit) */
        301, //uint16_t gdWakeupSymbolRxWindow;        /*!< The size of the window used to detect wakeup (76-301 gdBit) */
        180, //uint8_t gdWakeupSymbolTxIdle;           /*!< Number of bits used by the node to transmit the 'idle' part of a wakeup symbol (45-180 gdBit) */
        60,  //uint8_t gdWakeupSymbolTxLow;              /*!< Number of bits used by the node to transmit the LOW part of a wakeup symbol (15-60 gdBit) */
        2,   //uint32_t gListenNoise;
        0,   //uint8_t gNetworkManagementVectorLength; /*!< The length of the NMVector in byte */
        5000,//uint16_t gMacroPerCycle;                /*!< Number of macroticks in a communication cycle (10 - 16000MT) */
        8,   //uint8_t gMaxWithoutClockCorrectionFatal;
        6,   //uint8_t gMaxWithoutClockCorrectionPassive;
        90,   //uint16_t gNumberOfMinislots;
        80,  //uint16_t gNumberOfStaticSlots;
        4985,//uint16_t gOffsetCorrectionStart;        //!< Start of the offset correction phase within the NIT,
                                                     //expressed as the number of macroticks from the start of cycle (9 - 15999 MT)
                                                     //Note that this value should greater than
                                                     //gdStaticSlot* gNumberOfStaticSlots + gdMinislot*gNumberOfMinislots + gdSymbolWindow */
        10,  //uint8_t gPayloadLengthStatic;           /*!< Payload length of a static frame */
        10,   //uint8_t gSyncNodeMax;                   /*!< Maximum number of nodes that may send frames with the sync frame indicator bit set to one. */

};

//初始化flexray总线的node参数
FlexrayNodeParameter_t mFlexrayNodeParameter{
        401202,   //uint32_t pdListenTimeout;               /*!< Value for the startup listen timeout and wakeup listen timeout */
        9,        //uint8_t pMacroInitialOffsetA;           /*!< 2-68MT */
        9,        //uint8_t pMacroInitialOffsetB;           /*!< 2-68MT */
        16,        //uint8_t pPayloadLengthDynMax;           /*!< Maximum payload length for dynamic frames */
        1,        //uint8_t pAllowHaltDueToClock;			/*!< 1(true) or 0(false) */
        0,       //uint8_t pAllowPassiveToActive;          /*!< If set to zero, the CC is not allowed to transition from normal passive to normal active */
        2,        //uint8_t pClusterDriftDamping;            /*!< Local cluster drift damping factor used for rate correction (0-20uT) */
        212,      //uint16_t pdAcceptedStartupRange;
        1,        //uint16_t pDelayCompensationA;
        1,        //uint16_t pDelayCompensationB;
        1,       //uint16_t pKeySlotId;                    /*!< ID of the slot used to transmit the startup frame, sync frame, or designated single slot frame */
        1,        //uint8_t pKeySlotUsedForStartup;         /*!< key slot is startup frame or not ? 1(true) or 0(false) */
        1,        //uint8_t pKeySlotUsedForSync;            /*!< key slot is sync frame or not ? 1(true) or 0(false) */
        79,       //uint16_t pLatestTx;                     /*!< Number of the last minislot in which a frame transmission can start in the dynamic segment */
        23,       //uint8_t pMicroInitialOffsetA;
        23,       //uint8_t pMicroInitialOffsetB;
        200000,   //uint32_t pMicroPerCycle;                /*!< Nominal number of microticks in the communication cycle of the local node (640-640000 uT) */
        601,      //uint32_t pdMaxDrift;
        40,       //uint8_t pMicroPerMacroNom;
        601,      //uint16_t pRateCorrectionOut;            /*!< Magnitude of the maximum permissible rate correction value (2-1923 uT) */
        141,      //uint16_t pOffsetCorrectionOut;          /*!< Magnitude of the maximum permissible offset correction value (13-15567 uT) */
        0,        //uint8_t pSingleSlotEnabled;             //!< Flag indicating whether or not the node shall enter single slot mode following startup
                                                         //1(true) or 0(false)
        0,        //uint8_t pWakeupChannel;          //!< Channel used by the node to send a wakeup pattern: false -> A, true -> B
                                                         //1(true) or 0(false)
        44,       //uint8_t pWakeupPattern;                 /*!< Number of repetitions of the wakeup symbol that are combined to form a wakeup pattern when the node enters the POC:wakeup send state */
        56,       //uint16_t pDecodingCorrection;
        0,        //uint16_t keySlotHeaderCrc;             /*!< header CRC for key slot (0x00-0x7FF),must not be config, device computer it*/
        0,        //uint8_t pExternOffsetCorrection;        /*!< Number of microticks added or subtracted to the NIT to carry out a host-requested external offset correction (0-7uT) */
        0         //uint8_t pExternRateCorrection;          /*!< Number of microticks added or subtracted to the cycle to carry out a host-requested external rate correction (0-7uT) */


};
//初始化flexray总线的控制器参数
FlexrayCCParameter_t mFlexrayCCParameter{

        0,   //uint8_t freezeMode;                /*!< Transition to freeze mode or not(1/0) when system bus fail happen */
                                            /* 1(true) or 0(false) */
        1,   //uint8_t channelA;                  /*!< True: use channel A/False: not use channel A */
                                            /* 1(true) or 0(false) */
        1,   //uint8_t channelB;                  //!< True: If channel A is enabled, port B is connected  to channel B (dual channel mode)
                                                      // If channel A is disabled, port A is connected to channel B(single channel mode)
                                                      //False: not use channel B
                                            /* 1(true) or 0(false) */
        0,   //uint8_t syncFrameFilter;		/* 1(true) or 0(false) */
        UFR_BITRATE_10M    //uint8_t bitRate;    /*0(10Mbps),1(5Mbps),2(2.5Mbps),3(8Mbps)*/
};

//初始化单个时隙参数
FlexrayMsgBufferParameter_t mFlexrayMsgBufferParameter{

        MBID_DEFINE_BY_DEVICE,//MessageBufferID_t msgBufferID;/*0xff means msgBufferID is define by hardware*/
        31, //uint16_t frameID;           /*!< Slot ID in which frame is transmitted/received */
        0,  //uint8_t PPI;                   /*!< Payload Preamble Indicator */
                                    /* 1(true) or 0(false) */
        10, //uint8_t payloadLength;      /*!< Length in 2-byte unit, only for dynamic slot transmission */
        1,  //uint8_t isTx;                  /*!< True: Tx buffer, false: Rx buffer */
                                    /* 1(true) or 0(false) */
        1,  //uint8_t channelA;              /*!< True: enable transfer on channel A, false otherwise */
                                    /* 1(true) or 0(false) */
        1,  //uint8_t channelB;              //!< True: enable transfer on channel B, false otherwise.
                                        //Note that different combinations of channelA and channelB fields shall have
                                        //different effects. Please see Channel Assignment Description table in RM for details */
                                    /* 1(true) or 0(false) */
        0,  //uint8_t baseCycle;      /* 0~63, It must be less than the repetition cycle */
        1,  //uint8_t repetitionCycle; /* =2^N, that is N-th power of 2, where N is a number between 0 and 6 */

        0,  //uint8_t repeatTx;         //!< Only used if this is a tx individual buffer.
                                        //True: buffer is transmited again automatically.
                                        //False: buffer is trasmitted only once. */
                                        /* 1(true) or 0(false) */
};
#if 0
FlexrayMsgBufferParameter_t gFlexrayMsgBufferParameter[20]=
{
    {MBID_DEFINE_BY_DEVICE, 32,       0,   10,           1,    1,  1,       0,       1,              0,  },//(1)发送时隙
    {MBID_DEFINE_BY_DEVICE, 30 ,      0,   10,           0,    1,  1,       0,       1,              0,  },//(2)接收时隙
};
#else
//初始化多个时隙参数
FlexrayMsgBufferParameter_t gFlexrayMsgBufferParameter[30]=
// msgBufferID           frameID    PPI payloadLength isTx  chA chB  baseCycle repetitionCycle repeatTx
{
    {MBID_DEFINE_BY_DEVICE, 1,       0,   10,           1,    0,  1,       0,       1,              0,  },//发送时隙
    {MBID_DEFINE_BY_DEVICE, 2,       0,   10,           1,    0,  1,       0,       1,              0,  },
    {MBID_DEFINE_BY_DEVICE, 3,       0,   10,           1,    1,  1,       0,       1,              0,  },
    {MBID_DEFINE_BY_DEVICE, 4,       0,   10,           1,    1,  1,       0,       1,              0,  },
    {MBID_DEFINE_BY_DEVICE, 5,       0,   10,           1,    1,  1,       0,       1,              0,  },
    {MBID_DEFINE_BY_DEVICE, 6,       0,   10,           1,    1,  1,       0,       1,              0,  },
    {MBID_DEFINE_BY_DEVICE, 7,       0,   10,           1,    1,  1,       0,       1,              0,  },
    {MBID_DEFINE_BY_DEVICE, 8,       0,   10,           1,    1,  1,       0,       1,              0,  },
    {MBID_DEFINE_BY_DEVICE, 9,       0,   10,           1,    1,  1,       0,       1,              0,  },
    {MBID_DEFINE_BY_DEVICE, 10,      0,   10,           1,    1,  1,       0,       1,              0,  },

    {MBID_DEFINE_BY_DEVICE, 21,      0,   10,           0,    1,  1,       0,       1,              0,  },//接收时隙
    {MBID_DEFINE_BY_DEVICE, 22,      0,   10,           0,    1,  1,       0,       1,              0,  },
    {MBID_DEFINE_BY_DEVICE, 23,      0,   10,           0,    1,  1,       0,       1,              0,  },
    {MBID_DEFINE_BY_DEVICE, 24,      0,   10,           0,    1,  1,       0,       1,              0,  },
    {MBID_DEFINE_BY_DEVICE, 25,      0,   10,           0,    1,  1,       0,       1,              0,  },
    {MBID_DEFINE_BY_DEVICE, 26,      0,   10,           0,    1,  1,       0,       1,              0,  },
    {MBID_DEFINE_BY_DEVICE, 27,      0,   10,           0,    1,  1,       0,       1,              0,  },
    {MBID_DEFINE_BY_DEVICE, 28,      0,   10,           0,    1,  1,       0,       1,              0,  },
    {MBID_DEFINE_BY_DEVICE, 29,      0,   10,           0,    1,  1,       0,       1,              0,  },
    {MBID_DEFINE_BY_DEVICE, 30,      0,   10,           0,    1,  1,       0,       1,              0,  },

    {MBID_DEFINE_BY_DEVICE, 91,      0,   16,           0,    1,  1,       0,       1,              0,  },//接收动态时隙
    {MBID_DEFINE_BY_DEVICE, 92,      0,   16,           0,    1,  1,       0,       1,              0,  },//接收动态时隙

};
#endif
#endif





#if USE_FIFO_MODE
//下面的例子参数是全接收状态
FlerayFifoParameterFlat_t gParamSetFRFifo{
    0,//uint16_t messageIdAccVal;                 /* 16 bits *//*!< MESSAGE ID Acceptance Filter Value */
    0,//uint16_t messageIdAccMask;                /* 16 bits *//*!< MESSAGE ID Acceptance Filter Mask. This is ANDed with MESSAGE ID and compare with fidAccVal */
    0,//uint16_t frameIdRejVal;                   /* 11 bits *//*!< FRAME ID rejection Filter Mask */
    0x7FF,//uint16_t frameIdRejMask;                  /* 11 bits *//*!< FRAME ID rejection Filter Mask. This is ANDed with FRAME ID and compare with fidRejVal */
    0,//uint8_t rangeFilter1Enable;                   /*!< Range filter enable. 1(True): Enable. 0(False): Disable */
    0,//uint16_t rangeFilter1Upper;                   /* 11 bits *//*!< Frame ID upper value for range filter */
    0,//uint16_t rangeFilter1Lower;                   /* 11 bits *//*!< Frame ID lower value for range filter */
    0,//uint8_t rangeFilter1Mode;                     /*!< Range filter mode. 0:Accept mode. 1:Reject mode */
    0,//uint8_t rangeFilter2Enable;                   /*!< Range filter enable. 1(True): Enable. 0(False): Disable */
    0,//uint16_t rangeFilter2Upper;                   /* 11 bits *//*!< Frame ID upper value for range filter */
    0,//uint16_t rangeFilter2Lower;                   /* 11 bits *//*!< Frame ID lower value for range filter */
    0,//uint8_t rangeFilter2Mode;                     /*!< Range filter mode. 0:Accept mode. 1:Reject mode */
    0,//uint8_t rangeFilter3Enable;                   /*!< Range filter enable. 1(True): Enable. 0(False): Disable */
    0,//uint16_t rangeFilter3Upper;                   /* 11 bits *//*!< Frame ID upper value for range filter */
    0,//uint16_t rangeFilter3Lower;                   /* 11 bits *//*!< Frame ID lower value for range filter */
    0,//uint8_t rangeFilter3Mode;                     /*!< Range filter mode. 0:Accept mode. 1:Reject mode */
    0,//uint8_t rangeFilter4Enable;                   /*!< Range filter enable. 1(True): Enable. 0(False): Disable */
    0,//uint16_t rangeFilter4Upper;                   /* 11 bits *//*!< Frame ID upper value for range filter */
    0,//uint16_t rangeFilter4Lower;                   /* 11 bits *//*!< Frame ID lower value for range filter */
    0,//uint8_t rangeFilter4Mode;                     /*!< Range filter mode. 0:Accept mode. 1:Reject mode */

};
#endif




void Sleep(int msec)
{
    QTime dieTime = QTime::currentTime().addMSecs(msec);
    while( QTime::currentTime() < dieTime )
        QCoreApplication::processEvents(QEventLoop::AllEvents, 100);
}


#if USE_REPLAY_MODE
//threadRePlayProc::threadRePlayProc(QObject *parent):QThread(parent)
threadRePlayProc::threadRePlayProc(int instance)
{
    _instance = instance;
}
//用于回放数据的线程
void threadRePlayProc::run()
{
    int lastcycle=30;
    uint32 TxedEthPackCount = 0;
    uint32 ErrTimeoutCount = 0;

    uint8 ReplayFrameBuffer[ReplayframebufferMaxbyteslength];
    uint8 numberOfsubPacket = 10;
    uint8 numberOfTotalPacket = 0;
    uint8 packetnum;
    int bufferwrite_pos;

    while(1)
    {
        //第一步：组织要发送的数据包，为了让设备能够稳定、连续周期的回放数据，建议一个周期的回放数据封装成一个以太网报文
        //下面的例子数据由程序自动生成，用户可根据实际项目需要更改为读取文件或其他数据来源
        lastcycle += 1;
        lastcycle = lastcycle%64;
        bufferwrite_pos = 0;
        for(packetnum = 0; packetnum < numberOfsubPacket; packetnum++)
        {
            //组织发送包的原始数据
            uFlexrayFrame_t mReplayFlexrayFrame;
            mReplayFlexrayFrame.frameID = packetnum+1;
            /*if(lastcycle%2 == 0)
            {
                mReplayFlexrayFrame.frameID = packetnum*2+2;
            }else{
                mReplayFlexrayFrame.frameID = packetnum*2+1;
            }*/
            mReplayFlexrayFrame.payloadPreambleIndicator = 0;
            mReplayFlexrayFrame.cycleCount = lastcycle;
            mReplayFlexrayFrame.payloadLength = 10;

            for(int i=0; i<mReplayFlexrayFrame.payloadLength; i++)
            {
                mReplayFlexrayFrame.data[i] = (i << 8) + mReplayFlexrayFrame.frameID ;
            }

            //将发送包数据填入回放帧缓冲区
            FlexrayReplayPacketHeader_t mFlexrayReplayPacketHeader;
            mFlexrayReplayPacketHeader.frameID = mReplayFlexrayFrame.frameID;
            mFlexrayReplayPacketHeader.cycleCount = mReplayFlexrayFrame.cycleCount;
            mFlexrayReplayPacketHeader.cycleOffset = 0;
            mFlexrayReplayPacketHeader.PPI = mReplayFlexrayFrame.payloadPreambleIndicator;
            mFlexrayReplayPacketHeader.payloadLength = mReplayFlexrayFrame.payloadLength;
            memcpy(ReplayFrameBuffer+bufferwrite_pos, &mFlexrayReplayPacketHeader, sizeof(FlexrayReplayPacketHeader_t));
            bufferwrite_pos += sizeof(FlexrayReplayPacketHeader_t);
            memcpy(ReplayFrameBuffer+bufferwrite_pos, mReplayFlexrayFrame.data, mFlexrayReplayPacketHeader.payloadLength*2);
            bufferwrite_pos += mFlexrayReplayPacketHeader.payloadLength*2;

        }
        numberOfTotalPacket = numberOfsubPacket;
#if 0
        //增加1包动态时隙帧，填入回放帧缓冲区
        FlexrayReplayPacketHeader_t mFlexrayReplayPacketHeaderdy;
        mFlexrayReplayPacketHeaderdy.frameID = 71;
        mFlexrayReplayPacketHeaderdy.cycleCount = lastcycle;
        mFlexrayReplayPacketHeaderdy.cycleOffset = 0;
        mFlexrayReplayPacketHeaderdy.PPI = 0;
        mFlexrayReplayPacketHeaderdy.payloadLength = 16;
        memcpy(ReplayFrameBuffer+bufferwrite_pos, &mFlexrayReplayPacketHeaderdy, sizeof(FlexrayReplayPacketHeader_t));
        bufferwrite_pos += sizeof(FlexrayReplayPacketHeader_t);
        uint16 dydata[16];
        for(int i = 0; i < 16; i++)
        {
            dydata[i] = (i<<8) + 0x71;
        }
        memcpy(ReplayFrameBuffer+bufferwrite_pos, dydata, mFlexrayReplayPacketHeaderdy.payloadLength*2);
        bufferwrite_pos += mFlexrayReplayPacketHeaderdy.payloadLength*2;

        numberOfTotalPacket = numberOfsubPacket+1;
#endif
        if(bufferwrite_pos > ReplayframebufferMaxbyteslength)
        {
            printf("[ERROR] Replay framebuffer bytes length[%d] can't big than %d!",bufferwrite_pos,ReplayframebufferMaxbyteslength);
            return ;
        }

        //第一帧等待实际发送第一帧数据周期的前一个周期到来再开始回放数据
        /*
        if(isBeginning)
        {
            while(1)
            {
                UFr_GetFrNodeState_Wrapper(_instance, 0, frnodeState,curCycle);
                if(curCycle  == lastcycle - 1)
                {
                    isBeginning = 0;
                    break;
                }

                Sleep(1);
            }
        }*/
        //开始回放数据，调用UFr_ReplaySend函数将打包的数据发送给设备缓冲区，设备发送缓冲区如果已经满了，UFr_ReplaySend_Wrapper函数返回失败，
        //等待缓冲区的数据被发出一部分后再次尝试回放操作，直到发送成功
        int trycount = 10;
        while(trycount > 0)
        {
            trycount--;
            //静态时隙，动态1，累计numberOfTotalPacket帧数据打包成一个以太网包发送
            uint8 ret = UFr_ReplaySend_Wrapper(_instance,0,numberOfTotalPacket,ReplayFrameBuffer,bufferwrite_pos);

            if(ret == CMD_SUCCESS)
            {
                TxedEthPackCount++;
                //if(TxedEthPackCount%500 == 0)
                    printf("Replay[PacketCount=%d,bufflen=%d,cycle=%d] ret=%d, TxedEthPackCount=%d,ErrTimeoutCount=%d\r\n",numberOfTotalPacket,bufferwrite_pos,lastcycle,ret,TxedEthPackCount,ErrTimeoutCount);
                break;
             }else if(ret == CMD_FAIL_TIMEOUT){
                ErrTimeoutCount++;
                //if(TxedEthPackCount%500 == 0)
                    printf("Replay[PacketCount=%d,bufflen=%d,cycle=%d] ret=%d, TxedEthPackCount=%d,ErrTimeoutCount=%d\r\n",numberOfTotalPacket,bufferwrite_pos,lastcycle,ret,TxedEthPackCount,ErrTimeoutCount);
                    continue;
            }

        }
        //system("pause");
    }
}
#endif
int main(int argc, char *argv[])
{
    QCoreApplication a(argc, argv);
    uint8 ret;
    sint8 instance;
    uint8 frnodeState;
    uint8 curCycle;
    uint16 PSRstatus[4];

    char targetIP[] = "192.168.0.7";


    //打开设备
    instance = UFr_Open_Wrapper(targetIP);
    if(instance <= 0)
    {
        printf("Open flexray device fail!\r\n");
        system("pause");
        return 0;
    }
    printf("Open flexray device OK!\r\n");


#if USEFIBEX
    sint8 result = UFr_Fibex_Open("E:\\Fibex\\ZSDB123500_EF1E_4s_400V_BackboneFR_230831.xml");
    if(result == CMD_SUCCESS)
    {
        printf("UFr_Fibex_Open OK!\r\n");
        //输入cluster名称和ECU名称，如果函数执行成功，参数将保存在对应的结构体中
        result = UFr_Fibex_GetParameter("BackboneFR","CDM", &mFlexrayClusterParameter, &mFlexrayNodeParameter, &mFlexrayCCParameter);
        if(result != CMD_SUCCESS)
        {
            printf("UFr_Fibex_GetParameter fail(%d)!\r\n",result);
        }else{
            printf("UFr_Fibex_GetParameter OK!\r\n");
            //UFr_Fibex_Close();
        }
    }else{
        printf("UFr_Fibex_Open fail(%d)!\r\n",result);
    }
#endif

    //配置cluster参数    
    if(UFr_Set_Cluster_Parameter_Wrapper(instance,0,&mFlexrayClusterParameter) != CMD_SUCCESS)
    {
        printf("Set_Cluster_Parameter fail!\r\n");
        return 0;
    }
    printf("Set_Cluster_Parameter OK!\r\n");

    //配置节点参数    
    if(UFr_Set_Node_Parameter_Wrapper(instance,0,&mFlexrayNodeParameter) != CMD_SUCCESS)
    {
        printf("UFr_Set_Node_Parameter fail!\r\n");
        return 0;
    }
    printf("UFr_Set_Node_Parameter OK!\r\n");

    //配置CC参数
    if(UFr_Set_CC_Parameter_Wrapper(instance,0,&mFlexrayCCParameter) != CMD_SUCCESS)
    {
        printf("UFr_Set_CC_Parameter fail!\r\n");
        return 0;
    }
    printf("UFr_Set_CC_Parameter OK!\r\n");


    //配置发送、接收时隙参数
#if USEFIBEX
    char FrameNameStr[100];
    bool isFirstGet;
    ret = UFr_Fibex_GetFrameName_BySignalName("RoadInclnRoadIncln", FrameNameStr, &isFirstGet);
    if(ret == CMD_SUCCESS)
    {
        printf("Frame Name is: %s\r\n",FrameNameStr);
    }

    //从fibex文件获取一个发送帧的配置信息
#if USE_FRAME_NAME_TRANSMIT
    //dll 版本1.5.0以后支持下面函数配置slot
    ret = UFr_Fibex_Set_Slot_Parameter_Wrapper(instance, 0, "BcmVddmBackBoneFr00", true, false);
    if(ret != CMD_SUCCESS)
    {
        printf("UFr_Fibex_Set_Slot_Parameter_Wrapper FAIL(%d)!\r\n",ret);
        return 0;
    }
#else
    ret = UFr_Fibex_GetSlotParameter("CemBackBoneFr02", 1, 0, &gFlexrayMsgBufferParameter[0]);
    if(ret != CMD_SUCCESS)
    {
        printf("UFr_Fibex_GetSlotParameter FAIL(TX)[%d]!\r\n",ret);
        return 0;
    }
    //配置发送时隙参数
    ret = UFr_Set_Slot_Parameter_Wrapper(instance,0,&gFlexrayMsgBufferParameter[0]);
    if(ret != CMD_SUCCESS)
    {
        printf("UFr_Set_Slot_Parameter FAIL(TX)!\r\n");
        return 0;
    }
    printf("UFr_Set_Slot_Parameter ok[TX][used msgBufferID = %d]!\r\n",gFlexrayMsgBufferParameter[0].msgBufferID);


#endif


    //从fibex文件获取一个接收帧的配置信息
#if USE_FRAME_NAME_TRANSMIT
    //dll 版本1.5.0以后支持下面函数配置slot
    ret = UFr_Fibex_Set_Slot_Parameter_Wrapper(instance, 0, "BbmBcmBackBoneFr01", false, false);
    if(ret != CMD_SUCCESS)
    {
        printf("UFr_Fibex_Set_Slot_Parameter_Wrapper FAIL(%d)!\r\n",ret);
        return 0;
    }
#else
//    ret = UFr_Fibex_GetSlotParameter("BbmBcmBackBoneFr01", 0, 0, &gFlexrayMsgBufferParameter[1]);
//    if(ret != CMD_SUCCESS)
//    {
//        printf("UFr_Fibex_GetSlotParameter FAIL(RX)[%d]!\r\n",ret);
//        return 0;
//    }
//    //配置接收时隙参数
//    ret = UFr_Set_Slot_Parameter_Wrapper(instance,0,&gFlexrayMsgBufferParameter[1]);
//    if(ret != CMD_SUCCESS)
//    {
//        printf("UFr_Set_Slot_Parameter FAIL(RX)!\r\n");
//        return 0;
//    }
//    printf("UFr_Set_Slot_Parameter ok[RX][used msgBufferID = %d]!\r\n",gFlexrayMsgBufferParameter[1].msgBufferID);

#endif
    //从fibex文件获取一个接收帧的配置信息
#if USE_FRAME_NAME_TRANSMIT
    //dll 版本1.5.0以后支持下面函数配置slot
    ret = UFr_Fibex_Set_Slot_Parameter_Wrapper(instance, 0, "BbmBcmBackBoneFr02", false, false);
    if(ret != CMD_SUCCESS)
    {
        printf("UFr_Fibex_Set_Slot_Parameter_Wrapper FAIL(%d)!\r\n",ret);
        return 0;
    }
#else
//    ret = UFr_Fibex_GetSlotParameter("BbmBcmBackBoneFr02", 0, 0, &gFlexrayMsgBufferParameter[2]);
//    if(ret != CMD_SUCCESS)
//    {
//        printf("UFr_Fibex_GetSlotParameter FAIL(RX)[%d]!\r\n",ret);
//        return 0;
//    }
//    //配置接收时隙参数
//    ret = UFr_Set_Slot_Parameter_Wrapper(instance,0,&gFlexrayMsgBufferParameter[2]);
//    if(ret != CMD_SUCCESS)
//    {
//        printf("UFr_Set_Slot_Parameter FAIL(RX)!\r\n");
//        return 0;
//    }
//    printf("UFr_Set_Slot_Parameter ok[RX][used msgBufferID = %d]!\r\n",gFlexrayMsgBufferParameter[2].msgBufferID);


#endif
#else
    #if !USE_REPLAY_MODE
        //config send slot
        for(int i = 0; i < 10; i++)
        {
            ret = UFr_Set_Slot_Parameter_Wrapper(instance,0,&gFlexrayMsgBufferParameter[i]);
            if(ret != CMD_SUCCESS)
            {
                printf("UFr_Set_Slot_Parameter FAIL!\r\n");
                return 0;
            }
            printf("UFr_Set_Slot_Parameter ok[used msgBufferID = %d]!\r\n",gFlexrayMsgBufferParameter[i].msgBufferID);
        }
        printf("Send slot config OK!\r\n");
    //#endif
    //config rcv slot
    #if USE_FIFO_MODE
        //设置FIFO接收的过滤条件
        ret = UFr_Set_Fifo_Parameter_Wrapper(instance, 0, &gParamSetFRFifo);
        if(ret != CMD_SUCCESS)
        {
            printf("UFr_set_Fifo_parameter FAIL!\r\n");
            return 0;
        }
        printf("UFr_set_Fifo_parameter OK!\r\n");
    #else
        for(int i = 10; i < 22; i++)
        {
            ret = UFr_Set_Slot_Parameter_Wrapper(instance,0,&gFlexrayMsgBufferParameter[i]);
            if(ret != CMD_SUCCESS)
            {
                printf("UFr_Set_Slot_Parameter FAIL!\r\n");
                return 0;
            }
            printf("UFr_Set_Slot_Parameter ok[used msgBufferID = %d]!\r\n",gFlexrayMsgBufferParameter[i].msgBufferID);
        }
        printf("rcv slot config OK!\r\n");
    #endif
    #endif
#endif



    //配置使能
    if(UFr_Configure_Node_Wrapper(instance,0) != CMD_SUCCESS)
    {
        printf("UFr_Configure_Node fail!\r\n");
        return 0;
    }
    printf("UFr_Configure_Node OK!\r\n");

#if USE_TWO_KEYSLOT
    //配置节点keyslot，如果不执行UFr_SetFrPhyNodeKeySlot_Wrapper函数，设备将按照节点配置参数的keyslot值进行配置，默认不启动第二个keyslot
    //如果需要设备本身能建立FlexRay总线连接，进入normal active状态时，可以配制2个keyslot都使能
    FRPhyNodeKeySlotFlat_t mFRPhyNodeKeySlotFlat;
    //第一个keyslot可以沿用节点参数的配置，也可以根据需要修改为其他值，注意不能与总线上其他节点存在相同的keyslot值，否则无法建立总线连接
    mFRPhyNodeKeySlotFlat.keySlotId_1 = mFlexrayNodeParameter.pKeySlotId;
    mFRPhyNodeKeySlotFlat.keySlotUsedForSync_1 = mFlexrayNodeParameter.pKeySlotUsedForSync;
    mFRPhyNodeKeySlotFlat.keySlotUsedForStartup_1 = mFlexrayNodeParameter.pKeySlotUsedForStartup;
    //第二个keyslot可以找一个总线上没有被使用的keyslotID，本例采用最后一个静态时隙值，也可以根据需要修改为其他值
    //注意不能与总线上其他节点存在相同的keyslot值，否则无法建立总线连接
    //keySlotId_2的值如果为0，表示不启动第二个keyslot设置
    mFRPhyNodeKeySlotFlat.keySlotId_2 = mFlexrayClusterParameter.gNumberOfStaticSlots;
    mFRPhyNodeKeySlotFlat.keySlotUsedForSync_2 = 1;
    mFRPhyNodeKeySlotFlat.keySlotUsedForStartup_2 = 1;

    if(UFr_SetFrPhyNodeKeySlot_Wrapper(instance, 0, &mFRPhyNodeKeySlotFlat) != CMD_SUCCESS)
    {
        printf("UFr_SetFrPhyNodeKeySlot_Wrapper fail!\r\n");
        return 0;
    }
    printf("UFr_SetFrPhyNodeKeySlot_Wrapper OK!\r\n");
#endif

    //启动接收数据上传操作
    if(UFr_StartFrRxUpload_Wrapper(instance,0) != CMD_SUCCESS)
    {
        printf("UFr_StartFrRxUpload fail!\r\n");
        return 0;
    }
    printf("UFr_StartFrRxUpload OK! \r\n");
#if SEND_WAKEUP
    //发送唤醒指令
    if(UFr_SendWakeUp_Wrapper(instance,0) != CMD_SUCCESS)
    {
        printf("UFr_SendWakeUp fail!\r\n");
        return 0;
    }
    printf("UFr_SendWakeUp OK, wakeup cmd will be send at starting node! \r\n");
#endif

    //初始化时间戳，从0开始计时
   // UBus_SetTimeOffset_Wrapper(instance, 0);

#if USE_REPLAY_MODE

    if((ret = UFr_Set_WorkMode_Wrapper(instance, 0, FR_WORKDMODE_PLAYBACK, 0)) != CMD_SUCCESS)
    {
        printf("UFr_Set_WorkMode_Wrapper fail[%d]!\r\n",ret);
        return 0;
    }
    printf("UFr_Set_WorkMode_Wrapper OK! \r\n");
#else
    /*if((ret = UFr_Set_WorkMode_Wrapper(instance, 0, FR_WORKDMODE_NORMAL, 0)) != CMD_SUCCESS)
    {
        printf("UFr_Set_WorkMode_Wrapper fail[%d]!\r\n",ret);
        return 0;
    }*/
    printf("UFr_Set_WorkMode_Wrapper OK! \r\n");
#endif

    //启动节点，进入总线建立连接状态
    if((ret = UFr_Start_Node_Wrapper(instance,0)) != CMD_SUCCESS)
    {
        printf("UFr_Start_Node fail[%d]!\r\n",ret);
        return 0;
    }
    printf("UFr_Start_Node OK!\r\n");
#if SEND_WAKEUP
    UFr_GetFrPSRState_Wrapper(instance,0,PSRstatus);
    printf("PSR status is: %04X %04X %04X %04X \r\n",PSRstatus[0],PSRstatus[1],PSRstatus[2],PSRstatus[3]);

    uint16 wakeupStatus = PSRstatus[0]&0x0007;   // Select only WAKEUPSTATUS field

       switch(wakeupStatus)                        // Test Protocol State
       {
       case FrPSR0_WAKEUPSTATUS_UNDEFINED:                                // FR_WAKEUPSTATE_UNDEFINED
           printf("Wakeup Status undefined!\r\n");
           break;
       case FrPSR0_WAKEUPSTATUS_RECEIVED_HEADER:   // FR_WAKEUPSTATE_RECEIVED_HEADER
           printf("Wakeup Status Received_Header!\r\n");
           break;
       case FrPSR0_WAKEUPSTATUS_RECEIVED_WUP:      // FR_WAKEUPSTATE_RECEIVED_WUP
           printf("Wakeup Status Receiver_WUP!\r\n");
           break;
       case FrPSR0_WAKEUPSTATUS_COLLISION_HEADER:  // FR_WAKEUPSTATE_COLLISION_HEADER
           printf("Wakeup Status Collision_Header!\r\n");
           break;
       case FrPSR0_WAKEUPSTATUS_COLLISION_WUP:     // FR_WAKEUPSTATE_COLLISION_WUP
           printf("Wakeup Status Collision_WUP!\r\n");
           break;
       case FrPSR0_WAKEUPSTATUS_COLLISION_UNKNOWN: // FR_WAKEUPSTATE_COLLISION_UNKNOWN
           printf("Wakeup Status Collision_Unknow!\r\n");
           break;
       case FrPSR0_WAKEUPSTATUS_TRANSMITTED:       // FR_WAKEUPSTATE_TRANSMITTED
           printf("Wakeup Status Transmitted, send wakeup success!\r\n");
           break;
       default:
           break;
       }
#endif

    while(1)
    {
        //获得节点的状态
        UFr_GetFrNodeState_Wrapper(instance,0, frnodeState,curCycle );
        switch(frnodeState)
        {
            case FR_POCSTATE_CONFIG:
                printf("FlexRay Node is in status [config]\r\n");
                break;
            case FR_POCSTATE_DEFAULT_CONFIG:
                printf("FlexRay Node is in status [defconfig]\r\n");
                break;
            case FR_POCSTATE_HALT:
                printf("FlexRay Node is in status [halt]\r\n");
                break;
            case FR_POCSTATE_NORMAL_ACTIVE:
                printf("FlexRay Node is in status [normal active]\r\n");
                break;
            case FR_POCSTATE_NORMAL_PASSIVE:
                printf("FlexRay Node is in status [normal passive]\r\n");
                break;
            case FR_POCSTATE_READY:
                printf("FlexRay Node is in status [ready]\r\n");
                break;
            case FR_POCSTATE_STARTUP:
                printf("FlexRay Node is in status [startup]\r\n");
                break;
            case FR_POCSTATE_WAKEUP:
                printf("FlexRay Node is in status [wakeup]\r\n");
                break;
            default:
                printf("FlexRay Node is in status [unknown]\r\n");
                break;
        }
        if(frnodeState == FR_POCSTATE_NORMAL_ACTIVE)
        {
            printf("FlexRay bus connect created! You can start recieve and Transmit!\r\n");
            break;
        }
        Sleep(1000);

        //如果有按键退出程序，退出程序前应stop和close设备，否则需要重新启动设备才能进行配置
        if(kbhit())
        {

            if(UFr_Stop_Wrapper(instance,0) != CMD_SUCCESS)
            {
                printf("UFr_Stop fail!\r\n");
            }

            if(UFr_Close_Wrapper(instance) != CMD_SUCCESS)
            {
                printf("UFr_Close fail!\r\n");
            }
#if USEFIBEX
            UFr_Fibex_Close();
#endif
            printf("Device is closed, Press Enter to Exit!\r\n");
            return 0;
        }


    }



#if USE_REPLAY_MODE

    threadRePlayProc *pthreadRePlayProc;
    pthreadRePlayProc = new threadRePlayProc(instance);

    pthreadRePlayProc->start(QThread::TimeCriticalPriority);//start send thread

#else

    uFlexrayFrame_t mFlexrayFrame;
    int rcvcount=0;
    //int lastcycle=0;
    //int rcvcountslot[100]={0};
    //int slotmax = 0;

    //首先通过时隙1发送1帧数据
    mFlexrayFrame.payloadLength = mFlexrayClusterParameter.gPayloadLengthStatic;
    for(int i = 0; i < mFlexrayFrame.payloadLength; i++)
    {
        mFlexrayFrame.data[i] = 0x1234+i;
    }
#if USE_FRAME_NAME_TRANSMIT
    if(UFr_Fibex_Transmit_Wrapper(instance, 0, "BcmVddmBackBoneFr00",  (uint8*)mFlexrayFrame.data, mFlexrayFrame.payloadLength*2)!= CMD_SUCCESS)
    {
        printf("UFr_Transmit fail!\r\n");
    }else{
        printf("UFr_Transmit ok!\r\n");
    }

#else
    if(UFr_Transmit_Wrapper(instance,0,gFlexrayMsgBufferParameter[0].msgBufferID,mFlexrayFrame.data,mFlexrayFrame.payloadLength) != CMD_SUCCESS)
    {
        printf("UFr_Transmit fail!\r\n");
    }else{
        printf("UFr_Transmit ok!\r\n");
    }
#endif
    uFlexrayFrameHead_t uFlexrayFrameHead;
    uint16 rcvData[127];
    float sigval1;
    float sigval2;
    float signal3=0.01;
    while(1)
    {
        if((ret = UFr_Receive_Wrapper(instance, &uFlexrayFrameHead, rcvData,  1000))== CMD_SUCCESS)
        {
#if USEFIBEX
            char framename[100];
            ret = UFr_Fibex_GetFrameName(&uFlexrayFrameHead,  framename);

            if(ret == CMD_SUCCESS)
            {
                printf("FrameName=%s \r\n",framename);
            }

            //解析信号
            if(strcmp(framename, "BbmBcmBackBoneFr01") == 0)
            {
                ret = UFr_Fibex_decodeSignal(&uFlexrayFrameHead, (uint8*)rcvData, "BrkPedlTrvlTar", &sigval1);
                if(ret == CMD_SUCCESS)
                {
                    printf("signal: BrkPedlTrvlTar= %f\r\n",sigval1);
                }else{
                    printf("signal: BrkPedlTrvlTar can't be decode[%d]!\r\n",ret);
                }
                ret = UFr_Fibex_decodeSignal(&uFlexrayFrameHead, (uint8*)rcvData, "BrkPedlTrvlChks", &sigval2);
                if(ret == CMD_SUCCESS)
                {
                    printf("signal: BrkPedlTrvlChks= %d\r\n",(uint32)sigval2);
                }else{
                    printf("signal: BrkPedlTrvlChks can't be decode[%d]!\r\n",ret);
                }
            }

            if(strcmp(framename, "BbmBcmBackBoneFr02") == 0)
            {
                ret = UFr_Fibex_decodeSignal(&uFlexrayFrameHead, (uint8*)rcvData, "JBkpSig1aAY", &sigval1);
                if(ret == CMD_SUCCESS)
                {
                    printf("signal: JBkpSig1aAY= %f\r\n",sigval1);
                }else{
                    printf("signal: JBkpSig1aAY can't be decode[%d]!\r\n",ret);
                }

            }

#endif
            rcvcount++;            

            //if(rcvcount % 10000 == 0)
            {
                printf("sn=%d ",(int)uFlexrayFrameHead.serial_number);
                printf("time=%d.%06d ",(int)uFlexrayFrameHead.timestamp_s , (int)uFlexrayFrameHead.timestamp_us);
                printf("channel=%d ",uFlexrayFrameHead.Channel);
                printf("ID=%d ",uFlexrayFrameHead.frameID);
                printf("Cycle=%d ",uFlexrayFrameHead.cycleCount);
                printf("Length=%d ",uFlexrayFrameHead.payloadLength);
                printf("slotstatus=%04X ",uFlexrayFrameHead.slotStatus);
                printf("startup=%d ",uFlexrayFrameHead.startupFrameIndicator);
                printf("sync=%d ",uFlexrayFrameHead.syncFrameIndicator);
                printf("NFI=%d ",uFlexrayFrameHead.nullFrameIndicator);
                printf("PPI=%d ",uFlexrayFrameHead.payloadPreambleIndicator);
                printf("headCRC=%04X ",uFlexrayFrameHead.headerCrc);
                printf("data: ");

                for(int i=0; i<uFlexrayFrameHead.payloadLength;i++)
                {
                    //printf("%04X ",*(uint16*)(mFlexrayFrame.data+i));
                    printf("%04X ", rcvData[i]);
                }
                printf("\r\n");
            }

            UFr_ClearRcvBuffer_Wrapper(instance, 0);
            system("pause");

#if 1
#if USEFIBEX
            ret = UFr_Fibex_encodeSignal("RoadInclnRoadIncln", signal3, (uint8*)rcvData, 32);
            if(ret == CMD_SUCCESS)
            {
                printf("signal: RoadInclnRoadIncln encode ok!\r\n");
            }else{
                printf("signal: RoadInclnRoadIncln encode fail[%d]!\r\n",ret);
            }
            signal3 += 0.01;

            ret = UFr_Fibex_encodeSignal("EpbStsCntr", sigval2, (uint8*)rcvData, 32);
            if(ret == CMD_SUCCESS)
            {
                printf("signal: EpbStsCntr encode ok!\r\n");
            }else{
                printf("signal: EpbStsCntr encode fail[%d]!\r\n",ret);
            }

#endif

            //将接收到的flexray帧的数据部分通过发送时隙发送出去
    #if USE_FRAME_NAME_TRANSMIT
            if(UFr_Fibex_Transmit_Wrapper(instance, 0, "BcmVddmBackBoneFr00",  (uint8*)rcvData, uFlexrayFrameHead.payloadLength*2)!= CMD_SUCCESS)
            {
                printf("UFr_Transmit fail!\r\n");
            }else{
                printf("UFr_Transmit ok!\r\n");
            }

    #else
            if(UFr_Transmit_Wrapper(instance,0,gFlexrayMsgBufferParameter[0].msgBufferID,rcvData,uFlexrayFrameHead.payloadLength) != CMD_SUCCESS)
            {
                printf("UFr_Transmit fail!\r\n");
            }else{
                printf("UFr_Transmit ok!\r\n");
            }
    #endif
#endif
        }else{
            //printf("UFr_Receive_Wrapper return fail[%d]\r\n",ret);
        }


        //如果有按键退出程序，退出程序前应stop和close设备，否则需要重新启动设备才能进行配置
        if(kbhit())
        {

            if(UFr_StopFrRxUpload_Wrapper(instance,0) != CMD_SUCCESS)
            {
                printf("UFr_StopFrRxUpload fail!\r\n");
            }
            if(UFr_Stop_Wrapper(instance,0) != CMD_SUCCESS)
            {
                printf("UFr_Stop fail!\r\n");
            }

            if(UFr_Close_Wrapper(instance) != CMD_SUCCESS)
            {
                printf("UFr_Close fail!\r\n");
            }
            printf("Device is closed, Press Enter to Exit!\r\n");
#if USEFIBEX
            UFr_Fibex_Close();
#endif
            system("pause");
            return 0;
        }

    }
#endif
    return a.exec();

}

