#ifndef UBUSCOMMLIBWRAPPER_H
#define UBUSCOMMLIBWRAPPER_H


#define DLLIMPORT __declspec (dllexport)
#define MBID_DEFINE_BY_DEVICE    0xff
#define ReplayframebufferMaxbyteslength   1340


typedef unsigned char       boolean;


typedef signed char         sint8;
typedef unsigned char       uint8_t;
typedef unsigned char       uint8;
typedef signed short int    sint16;
typedef unsigned short int  uint16;
typedef unsigned short int  uint16_t;
typedef signed long int     sint32;
typedef unsigned long int   uint32;
typedef long long           sint64;
typedef unsigned long long  uint64;
/* Message buffer ID type */
typedef uint8_t MessageBufferID_t;

/*
 * Flexray global cluster parameters structure
 */
typedef struct fcpt
{
    uint8_t gColdstartAttempts;             /*!< Number of coldstart node in network (Range: 2->31) */
    uint8_t gdActionPointOffset;            /*!< Number of macroticks the action point is offset from the beginning of a static slot
                                                 or symbol window; value into range: 1-63MT. */
    uint8_t gdCASRxLowMax;                  /*!< Upper limit of the CAS acceptance window; value into range: 67-99 gdBit */
    uint8_t gdDynamicSlotIdlePhase;         /*!< Duration of the idle phase within a dynamic slot. from 0 to 2 */
    uint8_t gdMinislot;
    uint8_t gdMinislotActionPointOffset;    /*!< Number of macroticks the minislot action point is offset from the beginning of a minislot
                                                value into range: 1-31MT */
    uint16_t gdStaticSlot;                  /*!< Duration of a static slot (4->661 MT) */
    uint8_t gdSymbolWindow;
    uint8_t gdTSSTransmitter;               /*!< number of bits in the Transmission Start Sequence(3-15gdBit) */
    uint8_t gdWakeupSymbolRxIdle;           /*!< Number of bits used by the node to test the duration of
                                                 the 'idle' portion of a received wakeup symbol (14-59gdBit) */
    uint8_t gdWakeupSymbolRxLow;            /*!< Number of bits used by the node to test
                                                 the LOW portion of a received wakeup symbol (11-59gdBit) */
    uint16_t gdWakeupSymbolRxWindow;        /*!< The size of the window used to detect wakeup (76-301 gdBit) */
    uint8_t gdWakeupSymbolTxIdle;           /*!< Number of bits used by the node to transmit the 'idle' part of a wakeup symbol (45-180 gdBit) */
    uint8_t gdWakeupSymbolTxLow;              /*!< Number of bits used by the node to transmit the LOW part of a wakeup symbol (15-60 gdBit) */
    uint32  gListenNoise;
    uint8_t gNetworkManagementVectorLength; /*!< The length of the NMVector in byte */
    uint16_t gMacroPerCycle;                /*!< Number of macroticks in a communication cycle (10 - 16000MT) */
    uint8_t gMaxWithoutClockCorrectionFatal;
    uint8_t gMaxWithoutClockCorrectionPassive;
    uint16_t gNumberOfMinislots;
    uint16_t gNumberOfStaticSlots;
    uint16_t gOffsetCorrectionStart;        /*!< Start of the offset correction phase within the NIT,
                                                 expressed as the number of macroticks from the start of cycle (9 - 15999 MT)
                                                 Note that this value should greater than
                                                 gdStaticSlot* gNumberOfStaticSlots + gdMinislot*gNumberOfMinislots + gdSymbolWindow */
    uint8_t gPayloadLengthStatic;           /*!< Payload length of a static frame */
    uint8_t gSyncNodeMax;                   /*!< Maximum number of nodes that may send frames with the sync frame indicator bit set to one. */

} FlexrayClusterParameter_t;

/*
 * Flexray node parameters structure
 */
typedef struct fnpt
{
    uint32  pdListenTimeout;               /*!< Value for the startup listen timeout and wakeup listen timeout */
    uint8_t pMacroInitialOffsetA;           /*!< 2-68MT */
    uint8_t pMacroInitialOffsetB;           /*!< 2-68MT */
    uint8_t pPayloadLengthDynMax;           /*!< Maximum payload length for dynamic frames */
    uint8_t pAllowHaltDueToClock;			/*!< 1(true) or 0(false) */
    uint8_t pAllowPassiveToActive;          /*!< If set to zero, the CC is not allowed to transition from normal passive to normal active */
    uint8_t pClusterDriftDamping;            /*!< Local cluster drift damping factor used for rate correction (0-20uT) */
    uint16_t pdAcceptedStartupRange;
    uint16_t pDelayCompensationA;
    uint16_t pDelayCompensationB;
    uint16_t pKeySlotId;                    /*!< ID of the slot used to transmit the startup frame, sync frame, or designated single slot frame */
    uint8_t pKeySlotUsedForStartup;         /*!< key slot is startup frame or not ?
                                                 1(true) or 0(false) */
    uint8_t pKeySlotUsedForSync;            /*!< key slot is sync frame or not ?
                                                 1(true) or 0(false) */
    uint16_t pLatestTx;                     /*!< Number of the last minislot in which a frame transmission can start in the dynamic segment */
    uint8_t pMicroInitialOffsetA;
    uint8_t pMicroInitialOffsetB;
    uint32  pMicroPerCycle;                /*!< Nominal number of microticks in the communication cycle of the local node (640-640000 uT) */
    uint32  pdMaxDrift;
    uint8_t pMicroPerMacroNom;
    uint16_t pRateCorrectionOut;            /*!< Magnitude of the maximum permissible rate correction value (2-1923 uT) */
    uint16_t pOffsetCorrectionOut;          /*!< Magnitude of the maximum permissible offset correction value (13-15567 uT) */
    uint8_t pSingleSlotEnabled;             /*!< Flag indicating whether or not the node shall enter single slot mode following startup
                                                 1(true) or 0(false) */
    uint8_t pWakeupChannel;                 /*!< Channel used by the node to send a wakeup pattern: false -> A, true -> B
                                                 1(true) or 0(false) */
    uint8_t pWakeupPattern;                 /*!< Number of repetitions of the wakeup symbol that are combined to form a wakeup pattern when the node
                                                 enters the POC:wakeup send state */
    uint16_t pDecodingCorrection;
    uint16_t keySlotHeaderCrc;             /*!< header CRC for key slot (0x00-0x7FF) */
    uint8_t pExternOffsetCorrection;        /*!< Number of microticks added or subtracted to the NIT to carry out a host-requested external offset correction (0-7uT) */
    uint8_t pExternRateCorrection;          /*!< Number of microticks added or subtracted to the cycle to carry out a host-requested external rate correction (0-7uT) */

} FlexrayNodeParameter_t;

/*
 * bitrate defination
 */
typedef enum fbrt
{
    UFR_BITRATE_10M  = 0U,       /*!< 10 Mbit/s */
    UFR_BITRATE_5M   = 1U,       /*!< 5 Mbit/s */
    UFR_BITRATE_2_5M = 2U,       /*!< 2.5 Mbit/s */
    UFR_BITRATE_8M   = 3U        /*!< 8.0 Mbit/s */
} FlexrayBitrate_t;

typedef enum
{
    FR_WORKDMODE_NORMAL = 0,
    FR_WORKDMODE_PLAYBACK
} Fr_WORKMODE_type;

typedef enum
{
    FR_RECEIVE_NULLFRAME = 0,  //1:receive nullframe, 0:disable receive nullframe, default is 0
    FR_AUTORESTART_ONHALT,     //1:enable auto restart on Node POC entering halt state
                               //0:disable auto restart on Node POC entering halt state
                               //default is 1
} Fr_PARAMETER;

/*
 * Flexray Communication Controller parameters structure
 */
typedef struct fccpt
{
    uint8_t freezeMode;                /*!< Transition to freeze mode or not(1/0) when system bus fail happen */
                                    /* 1(true) or 0(false) */
    uint8_t channelA;                  /*!< True: use channel A/False: not use channel A */
                                    /* 1(true) or 0(false) */
    uint8_t channelB;                  /*!< True: If channel A is enabled, port B is connected  to channel B (dual channel mode)
                                               If channel A is disabled, port A is connected to channel B(single channel mode)
                                         False: not use channel B */
                                    /* 1(true) or 0(false) */
    uint8_t syncFrameFilter;		/* 1(true) or 0(false) */
    uint8_t bitRate;

} FlexrayCCParameter_t;

/*
 * Flexray slot parameters structure
 */
typedef struct fspt
{
    MessageBufferID_t msgBufferID;  /*!< Message buffer ID, Value with all 1s means that it is allocated by driver */

    uint16_t frameID;           /*!< Slot ID in which frame is transmitted/received */


    uint8_t PPI;                   /*!< Payload Preamble Indicator */
                                /* 1(true) or 0(false) */
    uint8_t payloadLength;      /*!< Length in 2-byte unit, only for dynamic slot transmission */

    uint8_t isTx;                  /*!< True: Tx buffer, false: Rx buffer */
                                /* 1(true) or 0(false) */
    uint8_t channelA;              /*!< True: enable transfer on channel A, false otherwise */
                                /* 1(true) or 0(false) */
    uint8_t channelB;              /*!< True: enable transfer on channel B, false otherwise.
                                    Note that different combinations of channelA and channelB fields shall have
                                    different effects. Please see Channel Assignment Description table in RM for details */
                                /* 1(true) or 0(false) */

    uint8_t baseCycle;      /* 0~63, It must be less than the repetition cycle */
    uint8_t repetitionCycle; /* =2^N, that is N-th power of 2, where N is a number between 0 and 6 */


    uint8_t repeatTx;              /*!< Only used if this is a tx individual buffer.
                                    True: buffer is transmited again automatically.
                                    False: buffer is trasmitted only once. */
                                /* 1(true) or 0(false) */

} FlexrayMsgBufferParameter_t;

/*
 * FlexRay FIFO parameters structure
 */
typedef struct
{
    uint16_t messageIdAccVal;                 /* 16 bits *//*!< MESSAGE ID Acceptance Filter Value */
    uint16_t messageIdAccMask;                /* 16 bits *//*!< MESSAGE ID Acceptance Filter Mask. This is ANDed with MESSAGE ID and compare with fidAccVal */
    uint16_t frameIdRejVal;                   /* 11 bits *//*!< FRAME ID rejection Filter Mask */
    uint16_t frameIdRejMask;                  /* 11 bits *//*!< FRAME ID rejection Filter Mask. This is ANDed with FRAME ID and compare with fidRejVal */
    uint8_t rangeFilter1Enable;                   /*!< Range filter enable. 1(True): Enable. 0(False): Disable */
    uint16_t rangeFilter1Upper;                   /* 11 bits *//*!< Frame ID upper value for range filter */
    uint16_t rangeFilter1Lower;                   /* 11 bits *//*!< Frame ID lower value for range filter */
    uint8_t rangeFilter1Mode;                     /*!< Range filter mode. 0:Accept mode. 1:Reject mode */
    uint8_t rangeFilter2Enable;                   /*!< Range filter enable. 1(True): Enable. 0(False): Disable */
    uint16_t rangeFilter2Upper;                   /* 11 bits *//*!< Frame ID upper value for range filter */
    uint16_t rangeFilter2Lower;                   /* 11 bits *//*!< Frame ID lower value for range filter */
    uint8_t rangeFilter2Mode;                     /*!< Range filter mode. 0:Accept mode. 1:Reject mode */
    uint8_t rangeFilter3Enable;                   /*!< Range filter enable. 1(True): Enable. 0(False): Disable */
    uint16_t rangeFilter3Upper;                   /* 11 bits *//*!< Frame ID upper value for range filter */
    uint16_t rangeFilter3Lower;                   /* 11 bits *//*!< Frame ID lower value for range filter */
    uint8_t rangeFilter3Mode;                     /*!< Range filter mode. 0:Accept mode. 1:Reject mode */
    uint8_t rangeFilter4Enable;                   /*!< Range filter enable. 1(True): Enable. 0(False): Disable */
    uint16_t rangeFilter4Upper;                   /* 11 bits *//*!< Frame ID upper value for range filter */
    uint16_t rangeFilter4Lower;                   /* 11 bits *//*!< Frame ID lower value for range filter */
    uint8_t rangeFilter4Mode;                     /*!< Range filter mode. 0:Accept mode. 1:Reject mode */
} FlexrayFifoParameterFlat_t;


typedef struct flexrayframet
{
	uint32 serial_number;
	uint32 timestamp_s;
	uint32 timestamp_us;
	uint8_t payloadPreambleIndicator;
	uint8_t nullFrameIndicator;			/* 1(true) or 0(false) */
	uint8_t syncFrameIndicator;			/* 1(true) or 0(false) */
	uint8_t startupFrameIndicator;		/* 1(true) or 0(false) */
	uint16_t frameID;
	uint8_t  Channel;
	uint8_t cycleCount;
	uint8_t payloadLength;
	uint16_t headerCrc;
	uint16_t slotStatus;
	uint16 data[127];

} uFlexrayFrame_t;

typedef struct flexrayframethead
{
	uint32 serial_number;
	uint32 timestamp_s;
	uint32 timestamp_us;
	uint8_t payloadPreambleIndicator;
	uint8_t nullFrameIndicator;			/* 1(true) or 0(false) */
	uint8_t syncFrameIndicator;			/* 1(true) or 0(false) */
	uint8_t startupFrameIndicator;		/* 1(true) or 0(false) */
	uint16_t frameID;
	uint8_t  Channel;
	uint8_t cycleCount;
	uint8_t payloadLength;
	uint16_t headerCrc;
	uint16_t slotStatus;

} uFlexrayFrameHead_t;

/*
 *
 */
typedef struct
{
    uint8_t rangeFilterEnable;                   /*!< Range filter enable. 1(True): Enable. 0(False): Disable */
    uint16_t rangeFilterUpper;                   /* 11 bits *//*!< Frame ID upper value for range filter */
    uint16_t rangeFilterLower;                   /* 11 bits *//*!< Frame ID lower value for range filter */
    uint8_t rangeFilterMode;                     /*!< Range filter mode. 0:Accept mode. 1:Reject mode */
} FlexrayRangeFilter_t;

/*
 * FlexRay FIFO parameters structure
 */
typedef struct
{
    uint8_t reserve;                           /* reserve byte,user don't need set */
    uint16_t messageIdAccVal;                 /* 16 bits *//*!< MESSAGE ID Acceptance Filter Value */
    uint16_t messageIdAccMask;                /* 16 bits *//*!< MESSAGE ID Acceptance Filter Mask. This is ANDed with MESSAGE ID and compare with fidAccVal */
    uint16_t frameIdRejVal;                   /* 11 bits *//*!< FRAME ID rejection Filter Mask */
    uint16_t frameIdRejMask;                  /* 11 bits *//*!< FRAME ID rejection Filter Mask. This is ANDed with FRAME ID and compare with fidRejVal */
    FlexrayRangeFilter_t rangeFilter[4];      /*!< Frame ID range Filter. Maximum number of range filter is 4 */
    uint8_t numberOfRangeFilter;
} FlerayFifoParameter_t;



/*
 * FlexRay replay frame header structure
 */
typedef struct ffrplht
{
    uint16_t frameID;
    uint32   cycleOffset;
    uint8_t cycleCount;
    uint8_t PPI;
    uint8_t payloadLength;
} FlexrayReplayPacketHeader_t;


struct p_fr_keyslotcfg_t
{
    uint16_t keySlotId_1;
    uint8_t keySlotUsedForStartup_1;
    uint8_t keySlotUsedForSync_1;

    uint16_t keySlotId_2;
    uint8_t keySlotUsedForStartup_2;
    uint8_t keySlotUsedForSync_2;
};
typedef struct p_fr_keyslotcfg_t FRPhyNodeKeySlotFlat_t;


//庯ֵ
typedef enum
{
	CMD_SUCCESS = 0,  //ִгɹ
	CMD_FAIL_STATUS,  //豸ص״̬ʧ
	CMD_FAIL_TIMEOUT, //ִгʱͨѶ
	CMD_FAIL_SOCKET,  //ؽsocketʧ
	CMD_FAIL_EXIT,    //˳ʱպܵķֵ
	CMD_FAIL_PARAMETER, //
    CMD_FAIL_INSTANCENOEXIST,//ʵŲڣUFr_OpenӦش0Чʵ
    CMD_FAIL_OPENFIBEX,   //FibexݿļʧܣļʽдFibex汾
    CMD_FAIL_PROCEDURE,  //̴ҪȵUFr_Openִгɹٵ
    CMD_FAIL_INVALIDFILE, //Чļ
    CMD_FAIL_SET_NODE_ATTIBUTE,  //ýڵʧ
    CMD_FAIL_SET_NODE_PARAMETER,  //ýڵʧ
    CMD_FAIL_SET_CC_PARAMETER,    //CCʧ
    CMD_FAIL_SIGNAL_NO_EXIST,     //صݿļвڸźŵĶ
    CMD_FAIL_NO_SPACE,            //ҪźŵĻռ䲻㣬ڻȶ󣬻źŶ
    CMD_FAIL_UNKNOW_SIGNAL,       //صfibexļûиźŵĶ
    CMD_FAIL_UNKNOW_FRAME,        //صfibexļûи֡Ķ
} CMD_RETURN_STATUS;

// flexrayڵЭ״̬
typedef enum
{
	FR_POCSTATE_DEFAULT_CONFIG = 0,
	FR_POCSTATE_CONFIG,
	FR_POCSTATE_WAKEUP,
	FR_POCSTATE_READY,
	FR_POCSTATE_NORMAL_PASSIVE,
	FR_POCSTATE_NORMAL_ACTIVE,
	FR_POCSTATE_HALT,
	FR_POCSTATE_STARTUP,
} Fr_POC_state_type;

// flexrayڵWAKEUPSTATUS״̬
typedef enum
{
    FrPSR0_WAKEUPSTATUS_UNDEFINED = 0,
    FrPSR0_WAKEUPSTATUS_RECEIVED_HEADER,
    FrPSR0_WAKEUPSTATUS_RECEIVED_WUP,
    FrPSR0_WAKEUPSTATUS_COLLISION_HEADER,
    FrPSR0_WAKEUPSTATUS_COLLISION_WUP,
    FrPSR0_WAKEUPSTATUS_COLLISION_UNKNOWN,
    FrPSR0_WAKEUPSTATUS_TRANSMITTED,
} Fr_WAKEUP_state_type;

typedef struct CANFrameHead
{
    uint8  channelNo;
    uint32 serial_number;
    uint32 timestamp_s;
    uint32 timestamp_us;
    uint32 canID;    
    uint8  protocolType; //0:CAN 2:CANFD  3:CANFD FAST    
    uint8  isExtendedFrame;
    uint8  isRTRFrame;
    uint8  payloadLength;
} uCANFrameHead_t;

typedef struct CANTxFrameHead
{
    uint32 canID;
    uint8  protocolType; //0:CAN 2:CANFD  3:CANFD FAST
    uint8  RFResponseFlag;//Remote frame response flag
    uint8  isExtendedFrame;
    uint8  isRTRFrame;
    uint8  payloadLength;
} uCANTxFrameHead_t;

typedef struct CANFDParamstruct{
    uint32 stdFrameRxId; /* Receive ID for standard frame */
    uint32 stdFrameRxIdMask; /* Receive ID mask for standard frame */
    uint32 extFrameRxId; /* Receive ID for extended frame */
    uint32 extFrameRxIdMask; /* Receive ID mask for extended frame */
    uint8_t reserve;    /*used for config MB max payload length, user can't cfg this value,default to 64 bytes*/
    /*
     * The bitrate settings for standard frames or for the arbitration phase of FD frames.
     */
    uint32 bitrate; /* The bitrate (bps) */
    /* Bit sampling point */
    /* User defined value (0 < bitSamplePoint < 1000), other value enable the automatically calculation */
    uint32 bitSamplePoint;
    /* Bit time parameter for CAN or CAN FD arbitration phase */
    /* To use following parameters if 'bitrate' field in this structure is set to 0 */
    uint16_t PRESDIV;    /* Prescaler Division factor setting */
    uint8_t PROPSEG;     /* Propagation Segment setting */
    uint8_t PSEG1;       /* Phase Segment 1 setting */
    uint8_t PSEG2;       /* Phase Segment 2 setting */
    uint8_t RJW;         /* ReSynchronization Jump Width setting */


    /*
     * The bitrate setting for the data phase of FD frames.
     */
    uint32 bitrateFD; /* The bitrate (bps) */
    /* Bit sampling point */
    /* User defined value (0 < bitSamplePoint < 1000), other value enable the automatically calculation */
    uint32 bitSamplePointFD;
    /* Bit time parameter for CAN FD data phase */
    /* To use following parameters if 'bitrateFD' field in this structure is set to 0 */
    uint16_t PRESDIV_FD; /* Prescaler Division factor setting */
    uint8_t PROPSEG_FD;  /* Propagation Segment setting */
    uint8_t PSEG1_FD;    /* Phase Segment 1 setting */
    uint8_t PSEG2_FD;    /* Phase Segment 2 setting */
    uint8_t RJW_FD;      /* ReSynchronization Jump Width setting */

    uint8_t autoRFR;    /* Automatic remote frame response */

    uint8_t disableTxFiFo; /*=1: disable tx FiFo, lost the frame when send fail*/
                           /*=0: enable  tx FiFo, retry send the frame when send fail*/
}tCANFDParamstruct;

enum CANFrameType{
    UnknownFrame = 0x0,
    DataFrame,
    ErrorFrame,
    RemoteRequestFrame,
    InvalidFrame
};

enum protocolType{
    CAN_TYPE = 0,
    CANFD_TYPE = 2,
    CANFDFAST_TYPE =3,
};

enum CANNodeID{
    CANNODE_0 = 0,
    CANNODE_1,
    CANNODE_2,
    CANNODE_3,
    CANNODE_4,
    CANNODE_5,
    CANNODE_6,
    CANNODE_7
};
#ifdef __cplusplus
extern "C" { /* using a C++ compiler */
#endif

	//typedef struct CommunicationLib CommunicationLibStruct; /* make the class opaque to the wrapper */


	//************************************************************************************
    //for flexray interface **************************************************************
	//************************************************************************************
	
    /**
    * @brief  flexray豸,Ӧкִǰã򿪳ɹ󷵻Чʵ
    * @since  1.0.0
    * @param  FrIPaddr     flexray豸IPַ
    * @return > 0ΪЧ豸ʵţʧ
    */
    DLLIMPORT sint8 UFr_Open_Wrapper(char *FrIPaddr);
	
	/**
    * @brief  汾Ϣ,̬汾豸̼汾,ӦUFr_Open_WrapperִгɹòܻϢ
    * ֻܻö̬İ汾Ϣ.
    * @since  2.0.0
    * @param  instance ִUFr_Open_Wrapperɹ󷵻ص豸ʵ
    * @param  dll_version ִгɹ󱣴涯̬汾Ϣ16ʾ2.0.0.1汾ֵΪ0x02000001
    * @param  firmware_version ִгɹ󱣴̼汾Ϣ16ʾ2.0.0.1汾ֵΪ0x02000001
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT  uint8 UBus_get_software_version_Wrapper(sint8 instance, uint32 *dll_version, uint32 *firmware_version);
	
    /**
    * @brief  flexray豸cluster
    * @since  1.0.0
    * @param  instance ִUFr_Open_Wrapperɹ󷵻ص豸ʵ
    * @param  controller_num ţflexrayӿڵcontroller_numΪ0
    * @param  fcp     ߲ṹ壬ο FlexrayClusterParameter_t Ķ
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT uint8 UFr_Set_Cluster_Parameter_Wrapper(sint8 instance, uint8 controller_num, const FlexrayClusterParameter_t *fcp);

    /**
    * @brief  flexray豸߽ڵ
    * @since  1.0.0
    * @param  instance ִUFr_Open_Wrapperɹ󷵻ص豸ʵ
    * @param  controller_num ţflexrayӿڵcontroller_numΪ0
    * @param  fnp     ڵṹ壬ο FlexrayNodeParameter_t Ķ
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT uint8 UFr_Set_Node_Parameter_Wrapper(sint8 instance, uint8 controller_num, const FlexrayNodeParameter_t *fnp);

    /**
    * @brief  flexray豸ͨѶ
    * @since  1.0.0
    * @param  instance ִUFr_Open_Wrapperɹ󷵻ص豸ʵ
    * @param  controller_num ţflexrayӿڵcontroller_numΪ0
    * @param  fccp     ͨѶṹ壬ο FlexrayCCParameter_t Ķ
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT uint8 UFr_Set_CC_Parameter_Wrapper(sint8 instance, uint8 controller_num, const FlexrayCCParameter_t *fccp);

    /**
    * @brief  flexray豸ʱ϶
    * @since  1.0.0
    * @param  instance ִUFr_Open_Wrapperɹ󷵻ص豸ʵ
    * @param  controller_num ţflexrayӿڵcontroller_numΪ0
    * @param  msgBufferParameter     ʱ϶ṹ壬ο FlexrayMsgBufferParameter_t Ķ
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT uint8 UFr_Set_Slot_Parameter_Wrapper(sint8 instance, uint8 controller_num, FlexrayMsgBufferParameter_t *msgBufferParameter);

    /**
    * @brief  flexray豸Fifo
    * @since  1.0.0
    * @param  instance ִUFr_Open_Wrapperɹ󷵻ص豸ʵ
    * @param  controller_num ţflexrayӿڵcontroller_numΪ0
    * @param  fifo_param_flat     FIFOṹ壬ο FlerayFifoParameterFlat_t Ķ
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT uint8 UFr_Set_Fifo_Parameter_Wrapper(sint8 instance, uint8 controller_num, FlexrayFifoParameterFlat_t *fifo_param_flat);

    /**
    * @brief  flexray豸keyslot
    * @since  1.0.0
    * @param  instance ִUFr_Open_Wrapperɹ󷵻ص豸ʵ
    * @param  controller_num ţflexrayӿڵcontroller_numΪ0
    * @param  pFRPhyNodeKeySlotFlat, reference to struct define of FRPhyNodeKeySlotFlat_t
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT uint8 UFr_SetFrPhyNodeKeySlot_Wrapper(sint8 instance, uint8 controller_num, FRPhyNodeKeySlotFlat_t *pFRPhyNodeKeySlotFlat);

    /**
    * @brief  flexray豸ĲЧĸִкҪñʹЧ
    * @since  1.0.0
    * @param  instance ִUFr_Open_Wrapperɹ󷵻ص豸ʵ
    * @param  controller_num ţflexrayӿڵcontroller_numΪ0
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT uint8 UFr_Configure_Node_Wrapper(sint8 instance, uint8 controller_num);

    /**
    * @brief  FlexRay߷wakeup patternϴsleep״̬Ľڵ㣬˺ֻʹܷͻѲʵʷڵʱ
    * @since  1.0.0
    * @param  instance ִUFr_Open_Wrapperɹ󷵻ص豸ʵ
    * @param  controller_num     ţflexrayߵĿΪ0
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT uint8 UFr_SendWakeUp_Wrapper(sint8 instance, uint8 controller_num);

    /**
    * @brief  set flexray node work mode, support normal mode and playback mode
    * @since  1.0.0
    * @param  instance ִUFr_Open_Wrapperɹ󷵻ص豸ʵ
    * @param  controller_num     ţflexrayߵĿΪ0
    * @param  workmode   FR_WORKDMODE_NORMAL,FR_WORKDMODE_PLAYBACK
    * @param  MTSenable   Enable MTS
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT uint8 UFr_Set_WorkMode_Wrapper(sint8 instance, uint8 controller_num, uint8 workmode, uint8 MTSenable);

	/**
    * @brief  趨һЩõ豸
    * @since  2.0.0
    * @param  instance ִUFr_Open_Wrapperɹ󷵻ص豸ʵ
    * @param  controller_num     ţflexrayߵĿΪ0
    * @param  ParameterIndex   òöֵȡֵοṹFr_PARAMETERĶ
    * @param  value   ҪõĲֵ
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT uint8 UFr_WriteValue_Wrapper(sint8 instance, uint8 controller_num, Fr_PARAMETER ParameterIndex, uint32 value);

    /**
    * @brief  ȡһЩõ豸
    * @since  2.0.0
    * @param  instance ִUFr_Open_Wrapperɹ󷵻ص豸ʵ
    * @param  controller_num     ţflexrayߵĿΪ0
    * @param  ParameterIndex   ȡöֵȡֵοṹFr_PARAMETERĶ
    * @param  value   ִгɹȡĲֵ
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT uint8 UFr_ReadValue_Wrapper(sint8 instance, uint8 controller_num, Fr_PARAMETER ParameterIndex, uint32 *value);

    /**
    * @brief  flexrayڵ㣬
    * @since  1.0.0
    * @param  instance ִUFr_Open_Wrapperɹ󷵻ص豸ʵ
    * @param  controller_num     ţflexrayߵĿΪ0
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT uint8 UFr_Start_Node_Wrapper(sint8 instance, uint8 controller_num);

    /**
    * @brief  ϴ
    *         ǷӿͨUFr_GetFrNodeStateá豸ĬϹرսϴܡ
    * @since  1.0.0
    * @param  instance ִUFr_Open_Wrapperɹ󷵻ص豸ʵ
    * @param  controller_num     ţflexrayߵĿΪ0
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT uint8 UFr_StartFrRxUpload_Wrapper(sint8 instance, uint8 controller_num);

    /**
    * @brief  ֹͣϴһҪstop豸֮ǰûҪʱá
    * @since  1.0.0
    * @param  instance ִUFr_Open_Wrapperɹ󷵻ص豸ʵ
    * @param  controller_num     ţflexrayߵĿΪ0
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT uint8 UFr_StopFrRxUpload_Wrapper(sint8 instance, uint8 controller_num);

    /**
    * @brief  flexray豸ǰЭ״̬UFr_Start_Nodeִкѭûȡ豸Э״̬
    * @since  1.0.0
    * @param  instance ִUFr_Open_Wrapperɹ󷵻ص豸ʵ
    * @param  controller_num     ţflexrayߵĿΪ0
    * @param  frnodeState        صЭ״̬οͶFr_POC_state_type
    * @param  curCycle        ߵǰ
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT uint8 UFr_GetFrNodeState_Wrapper(sint8 instance, uint8 controller_num, uint8 &frnodeState, uint8 &curCycle);

    /**
    * @brief  ĳȺ
    * @since  1.0.0
    * @param  instance ִUFr_Open_Wrapperɹ󷵻ص豸ʵ
    * @param  controller_num     ţflexrayߵĿΪ0
    * @param  NWVectorLength        ĳ
    * @param  NWVector        ݣʱӦṩ12ֽڵָ
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT uint8 UFr_GetFrNWVector_Wrapper(sint8 instance, uint8 controller_num, uint8 *NWVectorLength, uint8 *NWVector);

    /**
    * @brief  PSRĴ״ֵ̬
    * @since  1.0.0
    * @param  instance ִUFr_Open_Wrapperɹ󷵻ص豸ʵ
    * @param  controller_num     ţflexrayߵĿΪ0
    * @param  frPSRState        PSRĴֵʱӦṩ4ֵָ
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT uint8 UFr_GetFrPSRState_Wrapper(sint8 instance, uint8 controller_num, uint16 *frPSRState);

    /**
    * @brief  ȡ̬⻺Ľݰ
    * @since  1.0.0
    * @param  instance ִUFr_Open_Wrapperɹ󷵻ص豸ʵ
    * @return նеݰ
    */
    DLLIMPORT sint32 UFr_framesAvailable_Wrapper(sint8 instance);
	
	/**
    * @brief  FlexRayӿڽջ
    * @since  1.0.1
    * @param  instance ִUFr_Open_Wrapperɹ󷵻ص豸ʵ
    * @param  controller_num     ţflexrayߵĿΪ0
    * @return ο CMD_RETURN_STATUS 
    */
	DLLIMPORT uint8 UFr_ClearRcvBuffer_Wrapper(sint8 instance, uint8 controller_num);
	

    DLLIMPORT uint8 UFr_SetNodeRxTimeout_Wrapper(sint8 instance, uint8 controller_num, uint32 rxTimeout);

    /**
    * @brief  flexrayϢǰնûϢȴtimeout_ms˳
    * @since  1.0.0
    * @param  instance ִUFr_Open_Wrapperɹ󷵻ص豸ʵ
    * @param  rcvFrFrameHead    flexrayϢͷĽṹַṹ嶨ο uFlexrayFrameHead_t Ķ
    * @param  rcvFrDatabuffer    flexrayϢݵĻַ
    * @param  timeout_ms         ʱȴʱ䣬뵥λ
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT uint8 UFr_Receive_Wrapper(sint8 instance, uFlexrayFrameHead_t *rcvFrFrameHead, uint16 *rcvFrDatabuffer,  int timeout_ms);

    /**
    * @brief  طflexrayϢ1οԷͶFlexRayϢ
    * @since  1.0.0
    * @param  instance ִUFr_Open_Wrapperɹ󷵻ص豸ʵ
    * @param  controller_num     ţflexrayߵĿΪ0
    * @param  numberOfSubPacket  ָηͻframebuffer֡FlexRayϢ
    * @param  framebuffer        ͻָ,ÿ֡ͷֶοṹ FlexrayReplayPacketHeader_t Ķ
    * @param  framebuffer_byteslength         ͻֽڳ
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT uint8 UFr_ReplaySend_Wrapper(sint8 instance, uint8 controller_num, uint8 numberOfSubPacket, uint8 *framebuffer, uint16 framebuffer_byteslength);

    /**
    * @brief  flexrayϢ
    * @since  1.0.0
    * @param  instance ִUFr_Open_Wrapperɹ󷵻ص豸ʵ
    * @param  controller_num     ţflexrayߵĿΪ0
    * @param  messagebuffer_id   ϢIDţӦUFr_Set_Slot_ParameterصmsgBufferIDΪ룬ûԼ
    * @param  buffer             ݵĻ׵ַ
    * @param  wordlength         ֳ
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT uint8 UFr_Transmit_Wrapper(sint8 instance, uint8 controller_num, uint8 messagebuffer_id,  uint16 *buffer,	uint8 wordlength);

	DLLIMPORT uint8 UFr_FillData_beforeTransmit_MultiFrame_Wrapper(sint8 instance, uint8 bufferindex, uint8 messagebuffer_id,  uint8 *buffer,	uint8 bytelength);
    DLLIMPORT uint8 UFr_Fibex_FillData_beforeTransmit_MultiFrame_Wrapper(sint8 instance, uint8 controller_num, const char *inFrameName, uint8 bufferindex,  uint8 *buffer,	uint8 bytelength);
    DLLIMPORT uint8 UFr_Transmit_MultiFrame_Wrapper(sint8 instance, uint8 numberOfSubPacket, uint8 *CountOfSent, uint8 WaitForACK);


    /**
    * @brief  ֹͣflexray豸
    * @since  1.0.0
    * @param  instance ִUFr_Open_Wrapperɹ󷵻ص豸ʵ
    * @param  controller_num     ţflexrayߵĿΪ0
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT uint8 UFr_Stop_Wrapper(sint8 instance, uint8 controller_num);

    /**
    * @brief  رflexray豸
    * @since  1.0.0
    * @param  instance ִUFr_Open_Wrapperɹ󷵻ص豸ʵ
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT uint8 UFr_Close_Wrapper(sint8 instance);


	//************************************************************************************
    //for CAN interface*******************************************************************
	//************************************************************************************
	
	/**
    * @brief  CAN/CANFD豸ͨ,ӦڽCANӿںز֮ǰã򿪳ɹ󷵻Чʵ
    * @since  1.0.0
    * @param  FrIPaddr     flexray豸IPַ
	* @param  nodeindex    CAN豸ͨ
    * @return > 0ΪЧ豸ʵţʧ
    */
    DLLIMPORT sint8 UCAN_Open_Wrapper(char *FrIPaddr, uint8 nodeindex);

	/**
    * @brief  رCAN/CANFD豸
    * @since  1.0.0
    * @param  instance ִUCAN_Open_Wrapperɹ󷵻ص豸ʵ
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT sint8 UCAN_Close_Wrapper(sint8 instance);

	/**
    * @brief  CAN/CANFD豸ͨѶ
    * @since  1.0.0
    * @param  instance ִUCAN_Open_Wrapperɹ󷵻ص豸ʵ
    * @param  ptCANParamstruct   ߲ṹָ룬߲ǰҪԤȶý
	*         ֵοṹ tCANFDParamstruct Ķ塣
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT uint8 UCAN_Configure_Wrapper(sint8 instance, tCANFDParamstruct *ptCANParamstruct);

	/**
    * @brief  CAN/CANFD豸,Ӧòɺãͨ󼴿ɽзͺͽղ
    * @since  1.0.0
    * @param  instance ִUCAN_Open_Wrapperɹ󷵻ص豸ʵ
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT uint8 UCAN_Start_Wrapper(sint8 instance);

	/**
    * @brief  ֹͣCAN/CANFD豸,Ӧڳ˳ǰãֹͣͨܽзͺͽղ
    * @since  1.0.0
    * @param  instance ִUCAN_Open_Wrapperɹ󷵻ص豸ʵ
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT uint8 UCAN_Stop_Wrapper(sint8 instance);
	
	/**
    * @brief  CAN/CANFDϢ
    * @since  1.0.0
    * @param  instance ִUCAN_Open_Wrapperɹ󷵻ص豸ʵ
    * @param  uCANTxFrameHead    ͱĵ֡ͷṹ壬ο uCANTxFrameHead_t
    * @param  sendbuffer         ݵĻ׵ַ
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT uint8 UCAN_Transmit_Wrapper(sint8 instance, uCANTxFrameHead_t uCANTxFrameHead,	uint8 *sendbuffer);

	/**
    * @brief  CAN/CANFDϢ
    * @since  1.0.0
    * @param  instance ִUCAN_Open_Wrapperɹ󷵻ص豸ʵ
    * @param  outCANFrameHead    ձĵ֡ͷṹ壬ο uCANFrameHead_t
    * @param  databuffer         ݵĻ׵ַ
	* @param  timeout_ms         յĳʱʱ䣬λmsʱ˳
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT uint8 UCAN_Receive_Wrapper(sint8 instance, uCANFrameHead_t &outCANFrameHead, uint8 *databuffer, int timeout_ms);

	/**
    * @brief  ûаĽݰ
    * @since  1.0.0
    * @param  instance ִUCAN_Open_Wrapperɹ󷵻ص豸ʵ
    * @param  availableMsgCount  ִгɹ󷵻ػδӦյı
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT uint8 UCAN_framesAvailable_Wrapper(sint8 instance, sint32 *availableMsgCount);
	
	/**
    * @brief  ջδӦóȡCAN
    * @since  1.0.0
    * @param  instance ִUCAN_Open_Wrapperɹ󷵻ص豸ʵ
    * @return ο CMD_RETURN_STATUS 
    */
	DLLIMPORT uint8 UCAN_ClearRcvBuffer_Wrapper(sint8 instance);

    DLLIMPORT uint8 UCAN_SetNodeRxTimeout_Wrapper(sint8 instance, uint32 rxTimeout);


    //for device
    /**
    * @brief  豸ʱƫƣ豸ϵԶʼʱʱҪ󣬿Եô˺ʱƫ
    * @since  1.0.0
    * @param  instance ִUFr_Open_Wrapperɹ󷵻ص豸ʵ
    * @param  Second   ƫʱ䣬0ʾ0뿪ʼʱ
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT uint8 UBus_SetTimeOffset_Wrapper(sint8 instance, uint64 Second);


	
	//************************************************************************************
    //for Fibex file   *******************************************************************
	//************************************************************************************
    /**
    * @brief  ڴfibexļִд˺ǰҪɹִUFr_Open_WrapperѾɹ豸
    * @since  1.0.0
    * @param  FibexFileName ҪFibexļ·
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT sint8 UFr_Fibex_Open(const char *FibexFileName);


    /**
    * @brief  رfibexļʹfibexļϢʱִд˺رfibexļͷϵͳԴ
    * @since  1.0.0
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT sint8 UFr_Fibex_Close(void);


    /**
    * @brief  ڴfibexļȡ߲ҪûclusterƺECUַ
    *         ȷʹoutfcpoutfnpoutfccpӦĽṹкĳʼ
    * @since  1.0.0
    * @param  inClusterName ûcluster
    * @param  inControllerName ûECU
    * @param  outfcp   صcluster
    * @param  outfnp   صĽڵ
    * @param  outfccp   صͨѶ
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT sint8 UFr_Fibex_GetParameter(const char *inClusterName, const char *inControllerName,
                            FlexrayClusterParameter_t *outfcp,FlexrayNodeParameter_t *outfnp, FlexrayCCParameter_t *outfccp);

    /**
    * @brief  ͨźƲѯźڵ֡ƣ
    *         ȷʹoutFrameNameкʱ϶úʱ϶
    * @since  1.0.0
    * @param  signalname ûź
    * @param  outFrameName صĸź֡
    * @param  isFirstGet   ֡ǷΪһλãûɸݸòֵжǷҪø֡Ӧʱ϶
    *                      ΪtrueԽãҪã֮ǰúѯĳźѾڸ֡УҪͬ֡ʱ϶
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT sint8 UFr_Fibex_GetFrameName_BySignalName(const char *signalname, char *outFrameName, bool *isFirstGet);


    /**
    * @brief  ͨ֡ƻø֡ʱ϶Ϣ
    *         ȷʹoutmsgBufferParameterкUFr_Set_Slot_Parameter_Wrapperʱ϶á
    * @since  1.0.0
    * @param  inFrameName û֡
    * @param  isTx        ָ֡ǷΪ֡
    * @param  PPIflag     ָ֡ǰָʾ־
    * @param  outmsgBufferParameter   ִгɹýṹŸ֡ʱ϶ò
    *         ΪUFr_Set_Slot_Parameter_Wrapper
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT sint8 UFr_Fibex_GetSlotParameter(const char *inFrameName, bool isTx, bool PPIflag, FlexrayMsgBufferParameter_t *outmsgBufferParameter);

    /**
    * @brief  ͨ֡ƽжӦʱ϶ĲãϲUFr_Fibex_GetSlotParameterUFr_Set_Slot_Parameter_WrapperĲ
    *         ȷ֡Ϊ֡ʱʹUFr_Fibex_Transmit_Wrapperи֡ݷ͡
    * @since  1.0.0
    * @param  instance ִUFr_Open_Wrapperɹ󷵻ص豸ʵ
    * @param  controller_num     ţflexrayߵĿΪ0
    * @param  inFrameName û֡
    * @param  isTx        ָ֡ǷΪ֡
    * @param  PPIflag     ָ֡ǰָʾ־
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT uint8 UFr_Fibex_Set_Slot_Parameter_Wrapper(sint8 instance, uint8 controller_num, const char *inFrameName,
                                                         bool isTx, bool PPIflag);

    /**
    * @brief  ͨ֡ƽи֡ݷͲ
    * @since  1.0.0
    * @param  instance ִUFr_Open_Wrapperɹ󷵻ص豸ʵ
    * @param  controller_num     ţflexrayߵĿΪ0
    * @param  inFrameName û֡
    * @param  buffer        ݻֽ׵ַ
    * @param  wordlength    ֽڳ
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT uint8 UFr_Fibex_Transmit_Wrapper(sint8 instance, uint8 controller_num, const char *inFrameName,  uint8 *buffer,	uint8 bytelength);

	/**
    * @brief  flexrayϢ֡֡ƣǰնûϢȴtimeout_ms˳
    * @since  1.0.0
    * @param  instance ִUFr_Open_Wrapperɹ󷵻ص豸ʵ
    * @param  rcvFrFrameHead    flexrayϢͷĽṹַṹ嶨ο uFlexrayFrameHead_t Ķ
    * @param  rcvFrDatabuffer   flexrayϢݵĻַ
	* @param  outFrameName      ظ֡fibexļж֡
    * @param  timeout_ms        ʱȴʱ䣬뵥λ
    * @return ο CMD_RETURN_STATUS 
    */
	DLLIMPORT uint8 UFr_Fibex_Receive_Wrapper(sint8 instance, uFlexrayFrameHead_t *rcvFrFrameHead, uint8 *rcvFrDatabuffer, char *outFrameName, int timeout_ms);

    /**
    * @brief  ͨյFlexRay֡ͷϢø֡֡ơ
    * @since  1.0.0
    * @param  rcvFrFrameHead һ㽫պص֡ͷϢΪ
    * @param  outFrameName  ظ֡fibexļж֡
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT sint8 UFr_Fibex_GetFrameName(uFlexrayFrameHead_t *rcvFrFrameHead,  char *outFrameName);

    /**
    * @brief  ֡еָźֵ
    * @since  1.0.0
    * @param  rcvFrFrameHead һ㽫պص֡ͷϢΪ
    * @param  rcvFrDatabuffer һ㽫պص֡ϢΪ
    * @param  signalname  Ҫź
    * @param  signalval   ִгɹظźŵֵֵfloatͱʾ
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT sint8 UFr_Fibex_decodeSignal(uFlexrayFrameHead_t *rcvFrFrameHead, uint8 *rcvFrDatabuffer, const char *signalname, float *signalval);

    /**
    * @brief  ֡еָźִֵгɹҪUFr_Fibex_Transmit_WrapperUFr_Transmit_WrapperDataBufferָݷ
    * @since  1.0.0
    * @param  signalname  Ҫź
    * @param  signalval   Ҫźֵ
    * @param  DataBuffer  Ҫ͵֡ݲֵ׵ַ
    * @param  DataBufferBytelength ָ֡ݲֻֽڳ
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT sint8 UFr_Fibex_encodeSignal(const char *signalname, const float signalval, uint8 *DataBuffer, uint8 DataBufferBytelength);

//************************************************************************************
    //for AutoSar file   *******************************************************************
	//************************************************************************************
    /**
    * @brief  ڴAutoSarļִд˺ǰҪɹִUFr_Open_WrapperѾɹ豸
    * @since  1.0.0
    * @param  autosarFileName ҪFibexļ·
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT sint8 UFr_AutoSar_Open(const char *autosarFileName);


    /**
    * @brief  رAutoSarļʹAutoSarļϢʱִд˺رAutoSarļͷϵͳԴ
    * @since  1.0.0
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT sint8 UFr_AutoSar_Close(void);


    /**
    * @brief  ڴAutoSarļȡ߲ҪûclusterƺECUַ
    *         ȷʹoutfcpoutfnpoutfccpӦĽṹкĳʼ
    * @since  1.0.0
    * @param  inClusterName ûcluster
    * @param  inControllerName ûECU
    * @param  outfcp   صcluster
    * @param  outfnp   صĽڵ
    * @param  outfccp   صͨѶ
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT sint8 UFr_AutoSar_GetParameter(const char *inClusterName, const char *inControllerName,
                            FlexrayClusterParameter_t *outfcp,FlexrayNodeParameter_t *outfnp, FlexrayCCParameter_t *outfccp);

    /**
    * @brief  ͨźƲѯźڵ֡ƣ
    *         ȷʹoutFrameNameкʱ϶úʱ϶
    * @since  1.0.0
    * @param  signalname ûź
    * @param  outFrameName صĸź֡
    * @param  isFirstGet   ֡ǷΪһλãûɸݸòֵжǷҪø֡Ӧʱ϶
    *                      ΪtrueԽãҪã֮ǰúѯĳźѾڸ֡УҪͬ֡ʱ϶
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT sint8 UFr_AutoSar_GetFrameName_BySignalName(const char *signalname, char *outFrameName, bool *isFirstGet);


    /**
    * @brief  ͨ֡ƻø֡ʱ϶Ϣ
    *         ȷʹoutmsgBufferParameterкUFr_Set_Slot_Parameter_Wrapperʱ϶á
    * @since  1.0.0
    * @param  inFrameName û֡
    * @param  isTx        ָ֡ǷΪ֡
    * @param  PPIflag     ָ֡ǰָʾ־
    * @param  outmsgBufferParameter   ִгɹýṹŸ֡ʱ϶ò
    *         ΪUFr_Set_Slot_Parameter_Wrapper
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT sint8 UFr_AutoSar_GetSlotParameter(const char *inFrameName, bool isTx, bool PPIflag, FlexrayMsgBufferParameter_t *outmsgBufferParameter);

    /**
    * @brief  ͨ֡ƽжӦʱ϶ĲãϲUFr_Fibex_GetSlotParameterUFr_Set_Slot_Parameter_WrapperĲ
    *         ȷ֡Ϊ֡ʱʹUFr_Fibex_Transmit_Wrapperи֡ݷ͡
    * @since  1.0.0
    * @param  instance ִUFr_Open_Wrapperɹ󷵻ص豸ʵ
    * @param  controller_num     ţflexrayߵĿΪ0
    * @param  inFrameName û֡
    * @param  isTx        ָ֡ǷΪ֡
    * @param  PPIflag     ָ֡ǰָʾ־
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT uint8 UFr_AutoSar_Set_Slot_Parameter_Wrapper(sint8 instance, uint8 controller_num, const char *inFrameName,
                                                         bool isTx, bool PPIflag);

    /**
    * @brief  ͨ֡ƽи֡ݷͲ
    * @since  1.0.0
    * @param  instance ִUFr_Open_Wrapperɹ󷵻ص豸ʵ
    * @param  controller_num     ţflexrayߵĿΪ0
    * @param  inFrameName û֡
    * @param  buffer        ݻֽ׵ַ
    * @param  wordlength    ֽڳ
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT uint8 UFr_AutoSar_Transmit_Wrapper(sint8 instance, uint8 controller_num, const char *inFrameName,  uint8 *buffer,	uint8 bytelength);

	/**
    * @brief  flexrayϢ֡֡ƣǰնûϢȴtimeout_ms˳
    * @since  1.0.0
    * @param  instance ִUFr_Open_Wrapperɹ󷵻ص豸ʵ
    * @param  rcvFrFrameHead    flexrayϢͷĽṹַṹ嶨ο uFlexrayFrameHead_t Ķ
    * @param  rcvFrDatabuffer   flexrayϢݵĻַ
	* @param  outFrameName      ظ֡fibexļж֡
    * @param  timeout_ms        ʱȴʱ䣬뵥λ
    * @return ο CMD_RETURN_STATUS 
    */
	DLLIMPORT uint8 UFr_AutoSar_Receive_Wrapper(sint8 instance, uFlexrayFrameHead_t *rcvFrFrameHead, uint8 *rcvFrDatabuffer, char *outFrameName, int timeout_ms);

    /**
    * @brief  ͨյFlexRay֡ͷϢø֡֡ơ
    * @since  1.0.0
    * @param  rcvFrFrameHead һ㽫պص֡ͷϢΪ
    * @param  outFrameName  ظ֡fibexļж֡
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT sint8 UFr_AutoSar_GetFrameName(uFlexrayFrameHead_t *rcvFrFrameHead,  char *outFrameName);

    /**
    * @brief  ֡еָźֵ
    * @since  1.0.0
    * @param  rcvFrFrameHead һ㽫պص֡ͷϢΪ
    * @param  rcvFrDatabuffer һ㽫պص֡ϢΪ
    * @param  signalname  Ҫź
    * @param  signalval   ִгɹظźŵֵֵfloatͱʾ
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT sint8 UFr_AutoSar_decodeSignal(uFlexrayFrameHead_t *rcvFrFrameHead, uint8 *rcvFrDatabuffer, const char *signalname, float *signalval);

    /**
    * @brief  ֡еָźִֵгɹҪUFr_Fibex_Transmit_WrapperUFr_Transmit_WrapperDataBufferָݷ
    * @since  1.0.0
    * @param  signalname  Ҫź
    * @param  signalval   Ҫźֵ
    * @param  DataBuffer  Ҫ͵֡ݲֵ׵ַ
    * @param  DataBufferBytelength ָ֡ݲֻֽڳ
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT sint8 UFr_AutoSar_encodeSignal(const char *signalname, const float signalval, uint8 *DataBuffer, uint8 DataBufferBytelength);
	
    /**
    * @brief  autosarļжclustername
    * @since  2.0.0.0
    * @param  outBuffer ִгɹ󽫻ȡclustername洢ûoutBufferУڶʱԷֺ';'ָ
    * @param  outBufferLength  ûṩoutBufferֽڳ
    * @param  clusterCntTotal  autosarļжcluster
    * @param  clusterCntGetted κִлname
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT sint8 UFr_AutoSar_GetAllClusterName(char *outBuffer, uint32 outBufferLength, int *clusterCntTotal, int *clusterCntGetted);

    /**
    * @brief  autosarļжECUrname
    * @since  2.0.0.0
    * @param  outBuffer ִгɹ󽫻ȡECUname洢ûoutBufferУڶʱԷֺ';'ָ
    * @param  outBufferLength  ûṩoutBufferֽڳ
    * @param  ecuCntTotal  autosarļжECU
    * @param  ecuCntGetted κִлname
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT sint8 UFr_AutoSar_GetAllECUName(char *outBuffer, uint32 outBufferLength, int *ecuCntTotal, int *ecuCntGetted);

    /**
    * @brief  ͨclusternameautosarļжĸclusterµFrameName
    * @since  2.0.0.0
    * @param  clustername ûclustername
    * @param  outBuffer ִгɹ󽫻ȡframename洢ûoutBufferУڶʱԷֺ';'ָ
    * @param  outBufferLength  ûṩoutBufferֽڳ
    * @param  frameCntTotal  ûclusternameжframe
    * @param  frameCntGetted κִлframe
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT sint8 UFr_AutoSar_GetAllFrameName_ByClusterName(const char *clustername, char *outBuffer, uint32 outBufferLength, int *frameCntTotal, int *frameCntGetted);

    /**
    * @brief  ͨFrameNameautosarļжĸFrameµSignal
    * @since  2.0.0.0
    * @param  framename ûframename
    * @param  outBuffer ִгɹ󽫻ȡSignalName洢ûoutBufferУڶʱԷֺ';'ָ
    * @param  outBufferLength  ûṩoutBufferֽڳ
    * @param  signalCntTotal  ûFrameNameжSignal
    * @param  signalCntGetted κִлsignal
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT sint8 UFr_AutoSar_GetAllSignalName_ByFrameName(const char *framename, char *outBuffer, uint32 outBufferLength, int *signalCntTotal, int *signalCntGetted);

    /**
    * @brief  ͨECUNameautosarļжĸECUNameµFrameName
    * @since  2.0.0.0
    * @param  ECUname ûECUname
    * @param  outBuffer ִгɹ󽫻ȡSignalName洢ûoutBufferУڶʱԷֺ';'ָ
    * @param  outBufferLength  ûṩoutBufferֽڳ
    * @param  frameCntTotal  ûECUnameжframe
    * @param  frameCntGetted κִлframe
    * @param  isTx ʶ˴λõǷ֡ǽ֡
    * @return ο CMD_RETURN_STATUS 
    */
    DLLIMPORT sint8 UFr_AutoSar_GetAllFrameName_ByECUName(const char *ECUname, char *outBuffer, uint32 outBufferLength, int *frameCntTotal, int *frameCntGetted, bool isTx);





#ifdef __cplusplus
}
#endif

#endif // UBUSCOMMLIBWRAPPER_H
