###############################################################################
# ----------------------------------------------------------------------
 # @Author: Wangmingfei
 # @Date: 2023-12-22 10:37:40
 # @LastEditors: Wangmingfei
 # @LastEditTime: 2024-4-30 14:13:16
 # @Description: FlexRayDemo (Python)
# ----------------------------------------------------------------------
###############################################################################
import os
import platform
from ctypes import *
import ctypes
MBID_DEFINE_BY_DEVICE       = 0xff

CMD_SUCCESS                 = 0
CMD_FAIL_STATUS             = 1
CMD_FAIL_TIMEOUT            = 2
CMD_FAIL_SOCKET             = 3
CMD_FAIL_EXIT               = 4
CMD_FAIL_PARAMETER          = 5
CMD_FAIL_INSTANCENOEXIST    = 6
CMD_FAIL_OPENFIBEX          = 7
CMD_FAIL_PROCEDURE          = 8
CMD_FAIL_INVALIDFILE        = 9
CMD_FAIL_SET_NODE_ATTIBUTE  = 10
CMD_FAIL_SET_NODE_PARAMETER = 11
CMD_FAIL_SET_CC_PARAMETER   = 12
CMD_FAIL_SIGNAL_NO_EXIST    = 13
CMD_FAIL_NO_SPACE           = 14
CMD_FAIL_UNKNOW_SIGNAL      = 15
CMD_FAIL_UNKNOW_FRAME       = 16

FR_POCSTATE_DEFAULT_CONFIG  = 0
FR_POCSTATE_CONFIG          = 1
FR_POCSTATE_WAKEUP          = 2
FR_POCSTATE_READY           = 3
FR_POCSTATE_NORMAL_PASSIVE  = 4
FR_POCSTATE_NORMAL_ACTIVE   = 5
FR_POCSTATE_HALT            = 6
FR_POCSTATE_STARTUP         = 7

class FlexrayBitrate:
    UFR_BITRATE_10M                       = 0
    UFR_BITRATE_5M                        = 1
    UFR_BITRATE_2_5M                      = 2
    UFR_BITRATE_8M                        = 3

class CANFrameType:
    UnknownFrame                          = 0
    DataFrame                             = 1
    ErrorFrame                            = 2
    RemoteRequestFrame                    = 3
    InvalidFrame                          = 4

class Fr_WAKEUP_state_type:
    FrPSR0_WAKEUPSTATUS_UNDEFINED         = 0
    FrPSR0_WAKEUPSTATUS_RECEIVED_HEADER   = 1
    FrPSR0_WAKEUPSTATUS_RECEIVED_WUP      = 2
    FrPSR0_WAKEUPSTATUS_COLLISION_HEADER  = 3
    FrPSR0_WAKEUPSTATUS_COLLISION_WUP     = 4
    FrPSR0_WAKEUPSTATUS_COLLISION_UNKNOWN = 5
    FrPSR0_WAKEUPSTATUS_TRANSMITTED       = 6

class FlexrayClusterParameter_t(Structure):
    _fields_ = [
        ('gColdstartAttempts',                c_uint8),       # Number of coldstart node in network (Range: 2->31)
        ('gdActionPointOffset',               c_uint8),       # Number of macroticks the action point is offset from the beginning of a static slot or symbol window; value into range: 1-63MT.
        ('gdCASRxLowMax',                     c_uint8),       # Upper limit of the CAS acceptance window; value into range: 67-99 gdBit
        ('gdDynamicSlotIdlePhase',            c_uint8),       # Duration of the idle phase within a dynamic slot. from 0 to 2
        ('gdMinislot',                        c_uint8),
        ('gdMinislotActionPointOffset',       c_uint8),       # Number of macroticks the minislot action point is offset from the beginning of a minislot value into range: 1-31MT
        ('gdStaticSlot',                      c_uint16),      # Duration of a static slot (4->661 MT)
        ('gdSymbolWindow',                    c_uint8),
        ('gdTSSTransmitter',                  c_uint8),       # number of bits in the Transmission Start Sequence(3-15gdBit)
        ('gdWakeupSymbolRxIdle',              c_uint8),       # Number of bits used by the node to test the duration of the 'idle' portion of a received wakeup symbol (14-59gdBit)
        ('gdWakeupSymbolRxLow',               c_uint8),       # Number of bits used by the node to test the LOW portion of a received wakeup symbol (11-59gdBit)
        ('gdWakeupSymbolRxWindow',            c_uint16),      # The size of the window used to detect wakeup (76-301 gdBit)
        ('gdWakeupSymbolTxIdle',              c_uint8),       # Number of bits used by the node to transmit the 'idle' part of a wakeup symbol (45-180 gdBit)
        ('gdWakeupSymbolTxLow',               c_uint8),       # Number of bits used by the node to transmit the LOW part of a wakeup symbol (15-60 gdBit)
        ('gListenNoise',                      c_uint32),
        ('gNetworkManagementVectorLength',    c_uint8),       # The length of the NMVector in byte
        ('gMacroPerCycle',                    c_uint16),      # Number of macroticks in a communication cycle (10 - 16000MT)
        ('gMaxWithoutClockCorrectionFatal',   c_uint8),
        ('gMaxWithoutClockCorrectionPassive', c_uint8),
        ('gNumberOfMinislots',                c_uint16),
        ('gNumberOfStaticSlots',              c_uint16),
        ('gOffsetCorrectionStart',            c_uint16),      # Start of the offset correction phase within the NIT, expressed as the number of macroticks from the start of cycle (9 - 15999 MT) Note that this value should greater than gdStaticSlot* gNumberOfStaticSlots + gdMinislot*gNumberOfMinislots + gdSymbolWindow
        ('gPayloadLengthStatic',              c_uint8),       # Payload length of a static frame
        ('gSyncNodeMax',                      c_uint8)        # Maximum number of nodes that may send frames with the sync frame indicator bit set to one.
    ]

class FlexrayNodeParameter_t(Structure):
    _fields_ = [
        ("pdListenTimeout",                   c_uint32),
        ("pMacroInitialOffsetA",              c_uint8),
        ("pMacroInitialOffsetB",              c_uint8),
        ("pPayloadLengthDynMax",              c_uint8),
        ("pAllowHaltDueToClock",              c_uint8),
        ("pAllowPassiveToActive",             c_uint8),
        ("pClusterDriftDamping",              c_uint8),
        ("pdAcceptedStartupRange",            c_uint16),
        ("pDelayCompensationA",               c_uint16),
        ("pDelayCompensationB",               c_uint16),
        ("pKeySlotId",                        c_uint16),
        ("pKeySlotUsedForStartup",            c_uint8),
        ("pKeySlotUsedForSync",               c_uint8),
        ("pLatestTx",                         c_uint16),
        ("pMicroInitialOffsetA",              c_uint8),
        ("pMicroInitialOffsetB",              c_uint8),
        ("pMicroPerCycle",                    c_uint32),
        ("pdMaxDrift",                        c_uint32),
        ("pMicroPerMacroNom",                 c_uint8),
        ("pRateCorrectionOut",                c_uint16),
        ("pOffsetCorrectionOut",              c_uint16),
        ("pSingleSlotEnabled",                c_uint8),
        ("pWakeupChannel",                    c_uint8),
        ("pWakeupPattern",                    c_uint8),
        ("pDecodingCorrection",               c_uint16),
        ("keySlotHeaderCrc",                  c_uint16),
        ("pExternOffsetCorrection",           c_uint8),
        ("pExternRateCorrection",             c_uint8)
    ]

class FlexrayCCParameter_t(Structure):
    _fields_ = [
        ("freezeMode",                        c_uint8),
        ("channelA",                          c_uint8),
        ("channelB",                          c_uint8),
        ("syncFrameFilter",                   c_uint8),
        ("bitRate",                           c_uint8)
    ]

class FlexrayMsgBufferParameter_t(Structure):
    _fields_ = [
        ("msgBufferID",                       c_uint8),
        ("frameID",                           c_uint16),
        ("PPI",                               c_uint8),
        ("payloadLength",                     c_uint8),
        ("isTx",                              c_uint8),
        ("channelA",                          c_uint8),
        ("channelB",                          c_uint8),
        ("baseCycle",                         c_uint8),
        ("repetitionCycle",                   c_uint8),
        ("repeatTx",                          c_uint8)
    ]

class FlerayFifoParameterFlat(Structure):
    _fields_ = [
        ("messageIdAccVal",                   c_uint16),
        ("messageIdAccMask",                  c_uint16),
        ("frameIdRejVal",                     c_uint16),
        ("frameIdRejMask",                    c_uint16),
        ("rangeFilter1Enable",                c_uint8),
        ("rangeFilter1Upper",                 c_uint16),
        ("rangeFilter1Lower",                 c_uint16),
        ("rangeFilter1Mode",                  c_uint8),
        ("rangeFilter2Enable",                c_uint8),
        ("rangeFilter2Upper",                 c_uint16),
        ("rangeFilter2Lower",                 c_uint16),
        ("rangeFilter2Mode",                  c_uint8),
        ("rangeFilter3Enable",                c_uint8),
        ("rangeFilter3Upper",                 c_uint16),
        ("rangeFilter3Lower",                 c_uint16),
        ("rangeFilter3Mode",                  c_uint8),
        ("rangeFilter4Enable",                c_uint8),
        ("rangeFilter4Upper",                 c_uint16),
        ("rangeFilter4Lower",                 c_uint16),
        ("rangeFilter4Mode",                  c_uint8)
    ]
    def __init__(self):
        self.messageIdAccVal    = 0
        self.messageIdAccMask   = 0
        self.frameIdRejVal      = 0
        self.frameIdRejMask     = 0x7FF
        self.rangeFilter1Enable = 0
        self.rangeFilter1Upper  = 0
        self.rangeFilter1Lower  = 0
        self.rangeFilter1Mode   = 0
        self.rangeFilter2Enable = 0
        self.rangeFilter2Upper  = 0
        self.rangeFilter2Lower  = 0
        self.rangeFilter2Mode   = 0
        self.rangeFilter3Enable = 0
        self.rangeFilter3Upper  = 0
        self.rangeFilter3Lower  = 0
        self.rangeFilter3Mode   = 0
        self.rangeFilter4Enable = 0
        self.rangeFilter4Upper  = 0
        self.rangeFilter4Lower  = 0
        self.rangeFilter4Mode   = 0

class uFlexrayFrame_t(Structure):
    _fields_ = [
        ('serial_number',                     c_uint32),
        ('timestamp_s',                       c_uint32),
        ('timestamp_us',                      c_uint32),
        ('payloadPreambleIndicator',          c_uint8),
        ('nullFrameIndicator',                c_uint8),
        ('syncFrameIndicator',                c_uint8),
        ('startupFrameIndicator',             c_uint8),
        ('frameID',                           c_uint16),
        ('Channel',                           c_uint8),
        ('cycleCount',                        c_uint8),
        ('payloadLength',                     c_uint8),
        ('headerCrc',                         c_uint16),
        ('slotStatus',                        c_uint16),
        ('data',                              c_uint16*127)
    ]

class uFlexrayFrameHead_t(Structure):
    _fields_ = [
        ('serial_number',                     c_uint32),
        ('timestamp_s',                       c_uint32),
        ('timestamp_us',                      c_uint32),
        ('payloadPreambleIndicator',          c_uint8),
        ('nullFrameIndicator',                c_uint8),
        ('syncFrameIndicator',                c_uint8),
        ('startupFrameIndicator',             c_uint8),
        ('frameID',                           c_uint16),
        ('Channel',                           c_uint8),
        ('cycleCount',                        c_uint8),
        ('payloadLength',                     c_uint8),
        ('headerCrc',                         c_uint16),
        ('slotStatus',                        c_uint16)
    ]

class FlexrayRangeFilter_t(Structure):
    _fields_ = [
        ('rangeFilterEnable',                 c_uint8),
        ('rangeFilterUpper',                  c_uint16),
        ('rangeFilterLower',                  c_uint16),
        ('rangeFilterMode',                   c_uint8)
    ]

class FlerayFifoParameter_t(Structure):
    _fields_ = [
        ('reserve',                           c_uint8),
        ('messageIdAccVal',                   c_uint16),
        ('messageIdAccMask',                  c_uint16),
        ('frameIdRejVal',                     c_uint16),
        ('frameIdRejMask',                    c_uint16),
        ('rangeFilter',                       FlexrayRangeFilter_t*4),
        ('numberOfRangeFilter',               c_uint8)
    ]

class FlexrayReplayPacketHeader_t(Structure):
    _fields_ = [
        ('frameID',                           c_uint16),
        ('cycleOffset',                       c_uint32),
        ('cycleCount',                        c_uint8),
        ('PPI',                               c_uint8),
        ('payloadLength',                     c_uint8),
        ('keySlotUsedForSync_2',              c_uint8)
    ]

class FRPhyNodeKeySlotFlat_t(Structure):
    _fields_ = [
        ('keySlotId_1',                       c_uint16),
        ('keySlotUsedForStartup_1',           c_uint8),
        ('keySlotUsedForSync_1',              c_uint8),
        ('keySlotId_2',                       c_uint16),
        ('keySlotUsedForStartup_2',           c_uint8),
        ('keySlotUsedForSync_2',              c_uint8)
    ]

class UBusCommLibWrapper:
    def __init__(self):
        self.__dll = None
        if platform.system() == "Windows":
            arch = platform.architecture()[0]
            DLL = os.path.dirname(__file__) + "/x86/UBusCommLib.dll"
            dependency_path1 = os.path.dirname(__file__) + "/x86/Qt5Core.dll"
            dependency_path2 = os.path.dirname(__file__) + "/x86/Qt5Network.dll"
            dependency_path3 = os.path.dirname(__file__) + "/x86/Qt5Xml.dll"
            if arch == "64bit":
                DLL = os.path.dirname(__file__) + "/x64/UBusCommLib.dll"
                dependency_path1 = os.path.dirname(__file__) + "/x64/Qt5Core.dll"
                dependency_path2 = os.path.dirname(__file__) + "/x64/Qt5Network.dll"
                dependency_path3 = os.path.dirname(__file__) + "/x64/Qt5Xml.dll"
            ctypes.windll.LoadLibrary(dependency_path1)
            ctypes.windll.LoadLibrary(dependency_path2)
            ctypes.windll.LoadLibrary(dependency_path3)
            # self.__dll = windll.LoadLibrary(DLL)
            self.__dll = ctypes.CDLL(DLL) #该写法几乎支持所有python解释器版本。
        else:
            print("No support now!")
        if self.__dll == None:
            print("DLL couldn't be loaded!")

    def OpenDevice(self, address):
        try:
            return ctypes.c_int8(self.__dll.UFr_Open_Wrapper(address.encode("utf-8"))).value
        
        except:
            print("Exception on OpenDevice!") 
            raise

    def CloseDevice(self, handle):
        try:
            return ctypes.c_int8(self.__dll.UFr_Close_Wrapper(handle)).value
        except:
            print("Exception on CloseDevice!")
            raise
    def _print_ret(self,ret):
        RET = { CMD_SUCCESS    :                        "CMD_SUCCESS",
                CMD_FAIL_STATUS :                       "CMD_FAIL_STATUS" ,
                CMD_FAIL_TIMEOUT :                      "CMD_FAIL_TIMEOUT",
                CMD_FAIL_SOCKET :                       "CMD_FAIL_SOCKET",
                CMD_FAIL_EXIT :                         "CMD_FAIL_EXIT",
                CMD_FAIL_PARAMETER :                    "CMD_FAIL_PARAMETER",
                CMD_FAIL_INSTANCENOEXIST :              "CMD_FAIL_INSTANCENOEXIST",
                CMD_FAIL_OPENFIBEX :                    "CMD_FAIL_OPENFIBEX",
                CMD_FAIL_PROCEDURE :                    "CMD_FAIL_PROCEDURE",
                CMD_FAIL_INVALIDFILE :                  "CMD_FAIL_INVALIDFILE",
            CMD_FAIL_SET_NODE_ATTIBUTE :                "CMD_FAIL_SET_NODE_ATTIBUTE",
                CMD_FAIL_SET_NODE_PARAMETER :           "CMD_FAIL_SET_NODE_PARAMETER",
                CMD_FAIL_SET_CC_PARAMETER :             "CMD_FAIL_SET_CC_PARAMETER",
                CMD_FAIL_SIGNAL_NO_EXIST:               "CMD_FAIL_SIGNAL_NO_EXIST",
                CMD_FAIL_NO_SPACE       :               "CMD_FAIL_NO_SPACE",
                CMD_FAIL_UNKNOW_SIGNAL    :             "CMD_FAIL_UNKNOW_SIGNAL",
                CMD_FAIL_UNKNOW_FRAME     :             "CMD_FAIL_UNKNOW_FRAME",

        }
        print(f"API ret = {ret}")
        if CMD_SUCCESS != ret:
            if ret in RET.keys():
                print(f"API ret = {RET[ret]}")
            else:
                print(f"API ret = {ret}")
    def Set_Cluster_Parameter(self, device_handle, controller_num, clusterparameter):
        try:
            return ctypes.c_int8(self.__dll.UFr_Set_Cluster_Parameter_Wrapper(device_handle, controller_num, clusterparameter)).value
        except:
            print("Exception on Set_Cluster_Parameter!")
            raise

    def Set_Node_Parameter(self, device_handle, controller_num, nodeparameter):
        try:
            return ctypes.c_int8(self.__dll.UFr_Set_Node_Parameter_Wrapper(device_handle, controller_num, nodeparameter)).value
        except:
            print("Exception on Set_Node_Parameter!")
            raise

    def Set_CC_Parameter(self, device_handle, controller_num, channelconfigparameter):
        try:
            return ctypes.c_int8(self.__dll.UFr_Set_CC_Parameter_Wrapper(device_handle, controller_num, channelconfigparameter)).value
        except:
            print("Exception on Set_CC_Parameter!")
            raise

    def Set_Slot_Parameter(self, device_handle, controller_num, msgbufferparameter):
        try:
            return ctypes.c_int8(self.__dll.UFr_Set_Slot_Parameter_Wrapper(device_handle, controller_num, msgbufferparameter)).value
        except:
            print("Exception on Set_Slot_Parameter!")
            raise

    def Fifo_Parameter(self, device_handle, controller_num, fifoparameterflat):
        try:
            return ctypes.c_int8(self.__dll.UFr_Set_Fifo_Parameter_Wrapper(device_handle, controller_num, fifoparameterflat)).value
        except:
            print("Exception on Fifo_Parameter!")
            raise

    def SetFrPhyNodeKeySlot(self, device_handle, controller_num, frphynodekeyslotflat):
        try:
            return ctypes.c_int8(self.__dll.UFr_SetFrPhyNodeKeySlot_Wrapper(device_handle, controller_num, frphynodekeyslotflat)).value
        except:
            print("Exception on SetFrPhyNodeKeySlot!")
            raise

    def Configure_Node(self, device_handle, controller_num):
        try:
            return ctypes.c_int8(self.__dll.UFr_Configure_Node_Wrapper(device_handle, controller_num)).value
        except:
            print("Exception on Configure_Node!")
            raise

    def Start_Node(self, device_handle, controller_num):
        try:
            return ctypes.c_int8(self.__dll.UFr_Start_Node_Wrapper(device_handle, controller_num)).value
        except:
            print("Exception on Start_Node!")
            raise

    def Stop(self, device_handle, controller_num):
        try:
            return ctypes.c_int8(self.__dll.UFr_Stop_Wrapper(device_handle, controller_num)).value
        except:
            print("Exception on Stop!")
            raise

    def StartFrRxUpload(self, device_handle, controller_num):
        try:
            return ctypes.c_int8(self.__dll.UFr_StartFrRxUpload_Wrapper(device_handle, controller_num)).value
        except:
            print("Exception on StartFrRxUpload!")
            raise

    def StopFrRxUpload(self, device_handle, controller_num):
        try:
            return ctypes.c_int8(self.__dll.UFr_StopFrRxUpload_Wrapper(device_handle, controller_num)).value
        except:
            print("Exception on StopFrRxUpload!")
            raise

    def GetFrNodeState(self, device_handle, controller_num, frnodeState, curCycle):
        try:
            # frnodeState = c_int8(0)
            # curCycle    = c_int8(0)
            ret = ctypes.c_int8(self.__dll.UFr_GetFrNodeState_Wrapper(device_handle, controller_num, frnodeState, curCycle )).value
            return ret, frnodeState, curCycle
        except:
            print("Exception on GetFrNodeState!")
            raise

    def Receive(self, device_handle, rcvfrframehead, rcvfrdatabuffer, timeout):
        try:
            return ctypes.c_int8(self.__dll.UFr_Receive_Wrapper(device_handle, rcvfrframehead, rcvfrdatabuffer, timeout)).value
        except:
            print("Exception on Receive!")
            raise

    def Transmit(self, device_handle, controller_num, messagebufferid, txfrdatabuffer, wordlength):
        try:
            return ctypes.c_int8(self.__dll.UFr_Transmit_Wrapper(device_handle, controller_num, messagebufferid, txfrdatabuffer, wordlength)).value
        except:
            print("Exception on Transmit!")
            raise

    def ClearRcvBuffer(self, device_handle, controller_num):
        try:
            return ctypes.c_int8(self.__dll.UFr_ClearRcvBuffer_Wrapper(device_handle, controller_num)).value
        except:
            print("Exception on Transmit!")
            raise

    def Fibex_Open(self,Fibex_path):
        try:
            return ctypes.c_int8(self.__dll.UFr_Fibex_Open(ctypes.c_char_p(Fibex_path.encode("utf-8")))).value
        except:
            print("Exception on Fibex_Open!")
            raise

    def Fibex_GetParameter(self, inClusterName, inControllerName, clusterparameter, nodeparameter, channelconfigparameter):
        try:
            return ctypes.c_int8(self.__dll.UFr_Fibex_GetParameter(inClusterName.encode("utf-8"), inControllerName.encode("utf-8"),
                                                                   clusterparameter, nodeparameter, channelconfigparameter)).value
        except:
            print("Exception on Fibex_GetParameter!")
            raise

    def Fibex_GetSlotParameter(self, inFrameName, isTx, PPIflag, outmsgBufferParameter):
        try:
            return ctypes.c_int8(self.__dll.UFr_Fibex_GetSlotParameter(inFrameName.encode("utf-8"), isTx, PPIflag, outmsgBufferParameter)).value
        except:
            print("Exception on Fibex_GetSlotParameter!")
            raise

    def Fibex_GetFrameName(self, rcvFrFrameHead, outFrameName):
        try:
            return ctypes.c_int8(self.__dll.UFr_Fibex_GetFrameName(rcvFrFrameHead, outFrameName)).value
        except:
            print("Exception on Fibex_GetFrameName!")
            raise

    def Fibex_GetFrameName_BySignalName(self, signalname, outFrameName, isFirstGet):
        try:
            return ctypes.c_int8(self.__dll.UFr_Fibex_GetFrameName_BySignalName(signalname.encode("utf-8"), outFrameName, isFirstGet)).value
        except:
            print("Exception on Fibex_GetFrameName_BySignalName!")
            raise

    def Fibex_decodeSignal(self, rcvFrFrameHead, rcvFrDatabuffer, signalname, signalval):
        try:
            return ctypes.c_int8(self.__dll.UFr_Fibex_decodeSignal(rcvFrFrameHead, rcvFrDatabuffer, signalname.encode("utf-8"), signalval)).value
        except:
            print("Exception on Fibex_decodeSignal!")
            raise

    def Fibex_encodeSignal(self, signalname, signalval, DataBuffer, DataBufferBytelength):
        try:
            return ctypes.c_int8(self.__dll.UFr_Fibex_encodeSignal(signalname.encode("utf-8"), signalval, DataBuffer, DataBufferBytelength)).value
        except:
            print("Exception on Fibex_encodeSignal!")
            raise

    def Fibex_Set_Slot_Parameter(self, device_handle, controller_num, inFrameName, isTx, PPIflag):
        try:
            return ctypes.c_int8(self.__dll.UFr_Fibex_Set_Slot_Parameter_Wrapper(device_handle, controller_num, inFrameName.encode("utf-8"), isTx, PPIflag)).value
        except:
            print("Exception on Fibex_Set_Slot_Parameter!")
            raise

    def Fibex_Transmit(self, device_handle, controller_num, inFrameName, buffer, bytelength):
        try:
            return ctypes.c_int8(self.__dll.UFr_Fibex_Transmit_Wrapper(device_handle, controller_num, inFrameName.encode("utf-8"), buffer, bytelength)).value
        except:
            print("Exception on Fibex_Transmit!")
            raise       

    def Fibex_Close(self):
        try:
            return ctypes.c_int8(self.__dll.UFr_Fibex_Close()).value
        except:
            print("Exception on Fibex_Close!")
            raise

    def AutoSar_Open(self,Fibex_path):
        try:
            return ctypes.c_int8(self.__dll.UFr_AutoSar_Open(ctypes.c_char_p(Fibex_path.encode("utf-8")))).value
        except:
            print("Exception on AutoSar_Open!")
            raise

    def AutoSar_GetAllClusterName(self, outBuffer, outBufferLength, clusterCntTotal, clusterCntGetted):
        try:
            return ctypes.c_int8(self.__dll.UFr_AutoSar_GetAllClusterName(outBuffer, outBufferLength, clusterCntTotal, clusterCntGetted)).value
        except:
            print("Exception on AutoSar_GetAllClusterName!")
            raise

    def AutoSar_GetAllECUName(self, outBuffer, outBufferLength, ecuCntTotal, ecuCntGetted):
        try:
            return ctypes.c_int8(self.__dll.UFr_AutoSar_GetAllECUName(outBuffer, outBufferLength, ecuCntTotal, ecuCntGetted)).value
        except:
            print("Exception on AutoSar_GetAllECUName!")
            raise
    
    def AutoSar_GetAllFrameName_ByClusterName(self, clustername, outBuffer, outBufferLength, frameCntTotal, frameCntGetted):
        try:
            return ctypes.c_int8(self.__dll.UFr_AutoSar_GetAllFrameName_ByClusterName(clustername.encode("utf-8"), outBuffer, outBufferLength, frameCntTotal, frameCntGetted)).value
        except:
            print("Exception on AutoSar_GetAllFrameName_ByClusterName!")
            raise

    def AutoSar_GetAllFrameName_ByECUName(self, ECUname, outBuffer, outBufferLength, frameCntTotal, frameCntGetted, isTx):
        try:
            return ctypes.c_int8(self.__dll.UFr_AutoSar_GetAllFrameName_ByECUName(ECUname.encode("utf-8"), outBuffer, outBufferLength, frameCntTotal, frameCntGetted, isTx)).value
        except:
            print("Exception on AutoSar_GetAllFrameName_ByECUName!")
            raise
      
    def AutoSar_GetAllSignalName_ByFrameName(self, framename, outBuffer, outBufferLength, signalCntTotal, signalCntGetted):
        try:
            return ctypes.c_int8(self.__dll.UFr_AutoSar_GetAllSignalName_ByFrameName(framename.encode("utf-8"), outBuffer, outBufferLength, signalCntTotal, signalCntGetted)).value
        except:
            print("Exception on AutoSar_GetAllSignalName_ByFrameName!")
            raise

    def AutoSar_GetParameter(self, inClusterName, inControllerName, outfcp, outfnp, outfccp):
        try:
            return ctypes.c_int8(self.__dll.UFr_AutoSar_GetParameter(inClusterName.encode("utf-8"), inControllerName.encode("utf-8"), outfcp, outfnp, outfccp)).value
        except:
            print("Exception on AutoSar_GetParameter!")
            raise

    def AutoSar_GetFrameName_BySignalName(self, signalname, outFrameName, isFirstGet):
        try:
            return ctypes.c_int8(self.__dll.UFr_AutoSar_GetFrameName_BySignalName(signalname.encode("utf-8"), outFrameName, isFirstGet)).value
        except:
            print("Exception on AutoSar_GetFrameName_BySignalName!")
            raise

    def AutoSar_Set_Slot_Parameter(self, instance, controller_num, inFrameName, isTx, PPIflag):
        try:
            return ctypes.c_int8(self.__dll.UFr_AutoSar_Set_Slot_Parameter_Wrapper(instance, controller_num, inFrameName.encode("utf-8"), isTx, PPIflag)).value
        except:
            print("Exception on AutoSar_Set_Slot_Parameter!")
            raise

    def AutoSar_Transmit(self, instance, controller_num, inFrameName, buffer, bytelength):
        try:
            return ctypes.c_int8(self.__dll.UFr_AutoSar_Transmit_Wrapper(instance, controller_num, inFrameName.encode("utf-8"), buffer, bytelength)).value
        except:
            print("Exception on AutoSar!")
            raise

    def AutoSar_GetFrameName(self, rcvFrFrameHead, outFrameName):
        try:
            return ctypes.c_int8(self.__dll.UFr_AutoSar_GetFrameName(rcvFrFrameHead, outFrameName)).value
        except:
            print("Exception on AutoSar_GetFrameName!")
            raise

    def AutoSar_decodeSignal(self, rcvFrFrameHead, rcvFrDatabuffer, signalname, signalval):
        try:
            return ctypes.c_int8(self.__dll.UFr_AutoSar_decodeSignal(rcvFrFrameHead, rcvFrDatabuffer, signalname.encode("utf-8"), signalval)).value
        except:
            print("Exception on AutoSar_decodeSignal!")
            raise

    def AutoSar_encodeSignal(self, signalname, signalval, DataBuffer, DataBufferBytelength):
        try:
            return ctypes.c_int8(self.__dll.UFr_AutoSar_encodeSignal(signalname.encode("utf-8"), signalval, DataBuffer, DataBufferBytelength)).value
        except:
            print("Exception on AutoSar_encodeSignal!")
            raise

    def AutoSar_Close(self):
        try:
            return ctypes.c_int8(self.__dll.UFr_AutoSar_Close()).value
        except:
            print("Exception on AutoSar_Close!")
            raise

